/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line;

import io.questdb.cairo.TableUtils;
import io.questdb.client.Sender;
import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.DirectByteSlice;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.Closeable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLineSender
implements Utf8Sink,
Closeable,
Sender {
    protected final int capacity;
    private final long bufA;
    private final long bufB;
    private final DirectByteSlice bufferView = new DirectByteSlice();
    private final int maxNameLength;
    protected long hi;
    protected LineChannel lineChannel;
    protected long ptr;
    private boolean closed;
    private boolean enableValidation;
    private boolean hasColumns;
    private boolean hasSymbols;
    private boolean hasTable;
    private long lineStart;
    private long lo;
    private boolean quoted = false;

    public AbstractLineSender(LineChannel lineChannel, int capacity, int maxNameLength) {
        this.lineChannel = lineChannel;
        this.capacity = capacity;
        this.enableValidation = true;
        this.maxNameLength = maxNameLength;
        this.bufA = Unsafe.malloc(capacity, 34);
        this.bufB = Unsafe.malloc(capacity, 34);
        this.lo = this.bufA;
        this.hi = this.lo + (long)capacity;
        this.ptr = this.lo;
        this.lineStart = this.lo;
    }

    public void $(long timestamp) {
        this.putAsciiInternal(' ').put(timestamp);
        this.atNow();
    }

    public void $() {
        this.atNow();
    }

    @Override
    public final void atNow() {
        if (!this.hasColumns && !this.hasSymbols && this.enableValidation) {
            throw new LineSenderException((CharSequence)"no symbols or columns were provided");
        }
        this.putAsciiInternal('\n');
        this.lineStart = this.ptr;
        this.hasTable = false;
        this.hasColumns = false;
        this.hasSymbols = false;
    }

    public final void authenticate(String keyId, PrivateKey privateKey) {
        this.validateNotClosed();
        this.put(keyId);
        this.putAsciiInternal('\n');
        this.sendAll();
        byte[] challengeBytes = this.receiveChallengeBytes();
        byte[] signature = this.signAndEncode(privateKey, challengeBytes);
        int m = signature.length;
        for (int n = 0; n < m; ++n) {
            this.putAsciiInternal((char)signature[n]);
        }
        this.putAsciiInternal('\n');
        this.sendAll();
    }

    @Override
    public final AbstractLineSender boolColumn(CharSequence name, boolean value) {
        return this.field(name, value);
    }

    @Override
    public DirectByteSlice bufferView() {
        return this.bufferView.of(this.lo, (int)(this.ptr - this.lo));
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        try {
            this.flush();
        }
        finally {
            this.closed = true;
            this.lineChannel = Misc.free(this.lineChannel);
            Unsafe.free(this.bufA, this.capacity, 34);
            Unsafe.free(this.bufB, this.capacity, 34);
        }
    }

    public void disableValidation() {
        this.enableValidation = false;
    }

    public AbstractLineSender field(CharSequence name, long value) {
        this.writeFieldName(name).put(value).put('i');
        return this;
    }

    public AbstractLineSender field(CharSequence name, CharSequence value) {
        this.writeFieldName(name).put('\"');
        this.quoted = true;
        this.put(value);
        this.quoted = false;
        this.putAsciiInternal('\"');
        return this;
    }

    public AbstractLineSender field(CharSequence name, double value) {
        this.writeFieldName(name).put(value);
        return this;
    }

    public AbstractLineSender field(CharSequence name, boolean value) {
        this.writeFieldName(name).putAsciiInternal(value ? (char)'t' : 'f');
        return this;
    }

    @Override
    public void flush() {
        this.validateNotClosed();
        this.sendLine();
        this.ptr = this.lineStart = this.lo;
    }

    @Override
    public final AbstractLineSender longColumn(CharSequence name, long value) {
        return this.field(name, value);
    }

    public AbstractLineSender metric(CharSequence metric) {
        this.validateNotClosed();
        this.validateTableName(metric);
        if (this.hasTable) {
            throw new LineSenderException((CharSequence)"duplicated table. call sender.at() or sender.atNow() to finish the current row first");
        }
        if (metric.length() == 0) {
            throw new LineSenderException((CharSequence)"table name cannot be empty");
        }
        this.quoted = false;
        this.hasTable = true;
        this.put(metric);
        return this;
    }

    @Override
    public AbstractLineSender put(@Nullable CharSequence cs) {
        Utf8Sink.super.put(cs);
        return this;
    }

    @Override
    public AbstractLineSender put(char c) {
        Utf8Sink.super.put(c);
        return this;
    }

    @Override
    public AbstractLineSender put(@Nullable Utf8Sequence us) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractLineSender put(byte c) {
        this.validateNotClosed();
        if (this.ptr >= this.hi) {
            this.send00();
        }
        Unsafe.getUnsafe().putByte(this.ptr++, c);
        return this;
    }

    @Override
    public AbstractLineSender put(long value) {
        Numbers.append(this, value, false);
        return this;
    }

    @Override
    public AbstractLineSender putAscii(char @NotNull [] chars, int start, int len) {
        this.validateNotClosed();
        if (this.ptr + (long)len < this.hi) {
            Utf8s.strCpyAscii(chars, start, len, this.ptr);
        } else {
            this.send00();
            if (this.ptr + (long)len < this.hi) {
                Utf8s.strCpyAscii(chars, start, len, this.ptr);
            } else {
                throw new LineSenderException((CharSequence)"value too long. increase buffer size.");
            }
        }
        this.ptr += (long)len;
        return this;
    }

    @Override
    public AbstractLineSender putAscii(@Nullable CharSequence cs) {
        this.validateNotClosed();
        if (cs != null) {
            int l = cs.length();
            if (this.ptr + (long)l < this.hi) {
                Utf8s.strCpyAscii(cs, l, this.ptr);
            } else {
                this.send00();
                if (this.ptr + (long)l < this.hi) {
                    Utf8s.strCpyAscii(cs, l, this.ptr);
                } else {
                    throw new LineSenderException((CharSequence)"value too long. increase buffer size.");
                }
            }
            this.ptr += (long)l;
        }
        return this;
    }

    @Override
    public AbstractLineSender putAscii(char c) {
        this.validateNotClosed();
        switch (c) {
            case ' ': 
            case ',': 
            case '=': {
                if (!this.quoted) {
                    this.put((byte)92);
                }
            }
            default: {
                this.put((byte)c);
                break;
            }
            case '\n': 
            case '\r': {
                this.put((byte)92).put((byte)c);
                break;
            }
            case '\"': {
                if (this.quoted) {
                    this.put((byte)92);
                }
                this.put((byte)c);
                break;
            }
            case '\\': {
                this.put((byte)92).put((byte)92);
            }
        }
        return this;
    }

    public AbstractLineSender putAsciiInternal(char c) {
        this.put((byte)c);
        return this;
    }

    public AbstractLineSender putAsciiInternal(@Nullable CharSequence cs) {
        if (cs != null) {
            int l = cs.length();
            for (int i = 0; i < l; ++i) {
                this.putAsciiInternal(cs.charAt(i));
            }
        }
        return this;
    }

    @Override
    public AbstractLineSender putNonAscii(long lo, long hi) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final AbstractLineSender stringColumn(CharSequence name, CharSequence value) {
        return this.field(name, value);
    }

    @Override
    public final AbstractLineSender symbol(CharSequence name, CharSequence value) {
        return this.tag(name, value);
    }

    @Override
    public final AbstractLineSender table(CharSequence table) {
        return this.metric(table);
    }

    public AbstractLineSender tag(CharSequence tag, CharSequence value) {
        if (!this.hasTable) {
            throw new LineSenderException((CharSequence)"table expected");
        }
        if (this.hasColumns) {
            throw new LineSenderException((CharSequence)"symbols must be written before any other column types");
        }
        this.validateColumnName(tag);
        this.putAsciiInternal(',').put(tag);
        this.putAsciiInternal('=').put(value);
        this.hasSymbols = true;
        return this;
    }

    private static int findEOL(long ptr, int len) {
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(ptr + (long)i);
            if (b != 10) continue;
            return i;
        }
        return -1;
    }

    private byte[] receiveChallengeBytes() {
        int eol;
        int n;
        block3: {
            int rc;
            n = 0;
            do {
                if ((rc = this.lineChannel.receive(this.ptr + (long)n, this.capacity - n)) < 0) {
                    int errno = this.lineChannel.errno();
                    this.close();
                    throw new LineSenderException((CharSequence)"disconnected during authentication").errno(errno);
                }
                eol = AbstractLineSender.findEOL(this.ptr + (long)n, rc);
                if (eol != -1) break block3;
            } while ((n += rc) != this.capacity);
            this.close();
            throw new LineSenderException((CharSequence)"challenge did not fit into buffer");
        }
        int sz = n += eol;
        byte[] challengeBytes = new byte[sz];
        for (n = 0; n < sz; ++n) {
            challengeBytes[n] = Unsafe.getUnsafe().getByte(this.ptr + (long)n);
        }
        return challengeBytes;
    }

    private void sendLine() {
        if (this.lo < this.lineStart) {
            int len = (int)(this.lineStart - this.lo);
            this.lineChannel.send(this.lo, len);
        }
    }

    private void validateColumnName(CharSequence name) {
        if (!this.enableValidation) {
            return;
        }
        if (!TableUtils.isValidColumnName(name, this.maxNameLength)) {
            if (name.length() > this.maxNameLength) {
                throw new LineSenderException((CharSequence)"column name is too long: [name = ").putAsPrintable(name).put(", maxNameLength=").put(this.maxNameLength).put(']');
            }
            throw new LineSenderException((CharSequence)"column name contains an illegal char: '\\n', '\\r', '?', '.', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '-', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    private void validateTableName(CharSequence name) {
        if (!this.enableValidation) {
            return;
        }
        if (!TableUtils.isValidTableName(name, this.maxNameLength)) {
            if (name.length() > this.maxNameLength) {
                throw new LineSenderException((CharSequence)"table name is too long: [name = ").putAsPrintable(name).put(", maxNameLength=").put(this.maxNameLength).put(']');
            }
            throw new LineSenderException((CharSequence)"table name contains an illegal char: '\\n', '\\r', '?', ',', ''', '\"', '\\', '/', ':', ')', '(', '+', '*' '%%', '~', or a non-printable char: ").putAsPrintable(name);
        }
    }

    protected static long unitToNanos(ChronoUnit unit) {
        switch (unit) {
            case NANOS: {
                return 1L;
            }
            case MICROS: {
                return 1000L;
            }
            case MILLIS: {
                return 1000000L;
            }
            case SECONDS: {
                return 1000000000L;
            }
        }
        return unit.getDuration().toNanos();
    }

    protected void send00() {
        this.validateNotClosed();
        int len = (int)(this.ptr - this.lineStart);
        if (len == 0) {
            this.sendLine();
            this.ptr = this.lineStart = this.lo;
        } else if (len < this.capacity) {
            long target = this.lo == this.bufA ? this.bufB : this.bufA;
            Vect.memcpy(target, this.lineStart, len);
            this.sendLine();
            this.lineStart = this.lo = target;
            this.ptr = target + (long)len;
            this.hi = this.lo + (long)this.capacity;
        } else {
            throw new LineSenderException((CharSequence)"line too long. increase buffer size.");
        }
    }

    protected void sendAll() {
        this.validateNotClosed();
        if (this.lo < this.ptr) {
            int len = (int)(this.ptr - this.lo);
            this.lineChannel.send(this.lo, len);
            this.lineStart = this.ptr = this.lo;
        }
    }

    protected byte[] signAndEncode(PrivateKey privateKey, byte[] challengeBytes) {
        byte[] rawSignature;
        try {
            Signature sig = Signature.getInstance("SHA256withECDSA");
            sig.initSign(privateKey);
            sig.update(challengeBytes);
            rawSignature = sig.sign();
        }
        catch (InvalidKeyException ex) {
            this.close();
            throw new LineSenderException("invalid key", ex);
        }
        catch (SignatureException ex) {
            this.close();
            throw new LineSenderException("cannot sign challenge", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            this.close();
            throw new LineSenderException("unsupported signing algorithm", ex);
        }
        return Base64.getEncoder().encode(rawSignature);
    }

    protected final void validateNotClosed() {
        if (this.closed) {
            throw new LineSenderException((CharSequence)"sender already closed");
        }
    }

    protected AbstractLineSender writeFieldName(CharSequence name) {
        this.validateNotClosed();
        this.validateColumnName(name);
        if (this.hasTable) {
            if (!this.hasColumns) {
                this.putAsciiInternal(' ');
                this.hasColumns = true;
            } else {
                this.putAsciiInternal(',');
            }
            return this.put(name).putAsciiInternal('=');
        }
        throw new LineSenderException((CharSequence)"table expected");
    }
}

