/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsRegistry;
import io.questdb.std.Mutable;

public class PGMetrics
implements Mutable {
    private final LongGauge cachedSelectsGauge;
    private final LongGauge cachedUpdatesGauge;
    private final Counter completedQueriesCounter;
    private final LongGauge connectionCountGauge;
    private final Counter errorCounter;
    private final Counter listenerStateChangeCounter;
    private final Counter selectCacheHitCounter;
    private final Counter selectCacheMissCounter;
    private final Counter startedQueriesCounter;

    public PGMetrics(MetricsRegistry metricsRegistry) {
        this.connectionCountGauge = metricsRegistry.newLongGauge("pg_wire_connections");
        this.cachedSelectsGauge = metricsRegistry.newLongGauge("pg_wire_select_queries_cached");
        this.completedQueriesCounter = metricsRegistry.newCounter("pg_wire_queries_completed");
        this.startedQueriesCounter = metricsRegistry.newCounter("pg_wire_queries");
        this.cachedUpdatesGauge = metricsRegistry.newLongGauge("pg_wire_update_queries_cached");
        this.selectCacheHitCounter = metricsRegistry.newCounter("pg_wire_select_cache_hits");
        this.selectCacheMissCounter = metricsRegistry.newCounter("pg_wire_select_cache_misses");
        this.errorCounter = metricsRegistry.newCounter("pg_wire_errors");
        this.listenerStateChangeCounter = metricsRegistry.newCounter("pg_wire_listener_state_change_count");
    }

    public LongGauge cachedSelectsGauge() {
        return this.cachedSelectsGauge;
    }

    @Override
    public void clear() {
        this.cachedSelectsGauge.setValue(0L);
        this.cachedUpdatesGauge.setValue(0L);
        this.completedQueriesCounter.reset();
        this.connectionCountGauge.setValue(0L);
        this.errorCounter.reset();
        this.selectCacheHitCounter.reset();
        this.selectCacheMissCounter.reset();
        this.startedQueriesCounter.reset();
        this.listenerStateChangeCounter.reset();
    }

    public long completedQueriesCount() {
        return this.completedQueriesCounter.getValue();
    }

    public LongGauge connectionCountGauge() {
        return this.connectionCountGauge;
    }

    public Counter getErrorCounter() {
        return this.errorCounter;
    }

    public Counter listenerStateChangeCounter() {
        return this.listenerStateChangeCounter;
    }

    public void markComplete() {
        this.completedQueriesCounter.inc();
    }

    public void markStart() {
        this.startedQueriesCounter.inc();
    }

    public void resetQueryCounters() {
        this.startedQueriesCounter.reset();
        this.completedQueriesCounter.reset();
    }

    public Counter selectCacheHitCounter() {
        return this.selectCacheHitCounter;
    }

    public Counter selectCacheMissCounter() {
        return this.selectCacheMissCounter;
    }

    public long startedQueriesCount() {
        return this.startedQueriesCounter.getValue();
    }
}

