/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.griffin.CharacterStore;
import io.questdb.griffin.CharacterStoreEntry;
import io.questdb.griffin.ExpressionParserListener;
import io.questdb.griffin.GeoHashUtil;
import io.questdb.griffin.OperatorExpression;
import io.questdb.griffin.OperatorRegistry;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.SqlParser;
import io.questdb.griffin.SqlParserCallback;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntStack;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;
import io.questdb.std.LowerCaseAsciiCharSequenceObjHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.ObjStack;
import io.questdb.std.ObjectPool;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.Nullable;

public class ExpressionParser {
    private static final int BRANCH_ARRAY_TYPE_QUALIFIER_END = 21;
    private static final int BRANCH_ARRAY_TYPE_QUALIFIER_START = 20;
    private static final int BRANCH_BETWEEN_END = 14;
    private static final int BRANCH_BETWEEN_START = 13;
    private static final int BRANCH_CASE_CONTROL = 10;
    private static final int BRANCH_CASE_START = 9;
    private static final int BRANCH_CAST_AS = 11;
    private static final int BRANCH_COMMA = 1;
    private static final int BRANCH_CONSTANT = 4;
    private static final int BRANCH_DOT = 12;
    private static final int BRANCH_DOT_DEREFERENCE = 17;
    private static final int BRANCH_GEOHASH = 18;
    private static final int BRANCH_LAMBDA = 7;
    private static final int BRANCH_LEFT_BRACKET = 15;
    private static final int BRANCH_LEFT_PARENTHESIS = 2;
    private static final int BRANCH_LITERAL = 6;
    private static final int BRANCH_NONE = 0;
    private static final int BRANCH_OPERATOR = 5;
    private static final int BRANCH_RIGHT_BRACKET = 16;
    private static final int BRANCH_RIGHT_PARENTHESIS = 3;
    private static final int BRANCH_TIMESTAMP_ZONE = 19;
    private static final int IDX_ELSE = 2;
    private static final int IDX_THEN = 1;
    private static final int IDX_WHEN = 0;
    private static final Log LOG = LogFactory.getLog(ExpressionParser.class);
    private static final LowerCaseAsciiCharSequenceObjHashMap<CharSequence> allFunctions = new LowerCaseAsciiCharSequenceObjHashMap();
    private static final LowerCaseAsciiCharSequenceIntHashMap caseKeywords = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final IntHashSet moreCastTargetTypes = new IntHashSet();
    private static final IntHashSet nonLiteralBranches = new IntHashSet();
    private final OperatorRegistry activeRegistry;
    private final IntStack argStackDepthStack = new IntStack();
    private final CharacterStore characterStore;
    private final ObjectPool<ExpressionNode> expressionNodePool;
    private final ObjStack<ExpressionNode> opStack = new ObjStack();
    private final IntStack paramCountStack = new IntStack();
    private final ObjStack<Scope> scopeStack = new ObjStack();
    private final OperatorRegistry shadowRegistry;
    private final SqlParser sqlParser;

    ExpressionParser(OperatorRegistry activeRegistry, OperatorRegistry shadowRegistry, ObjectPool<ExpressionNode> expressionNodePool, SqlParser sqlParser, CharacterStore characterStore) {
        this.activeRegistry = activeRegistry;
        this.shadowRegistry = shadowRegistry;
        this.expressionNodePool = expressionNodePool;
        this.sqlParser = sqlParser;
        this.characterStore = characterStore;
    }

    public static int extractGeoHashSuffix(int position, CharSequence tok) throws SqlException {
        assert (tok.charAt(0) == '#');
        int tokLen = tok.length();
        if (tokLen > 1) {
            if (tokLen >= 3 && tok.charAt(tokLen - 3) == '/') {
                short bits = (short)(10 * tok.charAt(tokLen - 2) + tok.charAt(tokLen - 1) - 528);
                if (bits >= 1 && bits <= 60) {
                    return Numbers.encodeLowHighShorts((short)3, bits);
                }
                throw SqlException.$(position, "invalid bits size for GEOHASH constant: ").put(tok);
            }
            if (tok.charAt(tokLen - 2) == '/') {
                char du = tok.charAt(tokLen - 1);
                if (du >= '1' && du <= '9') {
                    return Numbers.encodeLowHighShorts((short)2, (short)(du - 48));
                }
                throw SqlException.$(position, "invalid bits size for GEOHASH constant: ").put(tok);
            }
        }
        return Numbers.encodeLowHighShorts((short)0, (short)(5 * Math.max(tokLen - 1, 0)));
    }

    public static boolean isGeoHashBitsConstant(CharSequence tok) {
        assert (tok.charAt(0) == '#');
        int len = tok.length();
        return len > 1 && tok.charAt(1) == '#';
    }

    public static boolean isGeoHashCharsConstant(CharSequence tok) {
        assert (tok.charAt(0) == '#');
        int len = tok.length();
        return len <= 1 || tok.charAt(1) != '#';
    }

    private static boolean cannotCastTo(int targetTag, boolean isFromNull) {
        return (targetTag < 1 || targetTag > 13) && (!isFromNull || targetTag != 18 && targetTag != 32) && !moreCastTargetTypes.contains(targetTag);
    }

    private static SqlException missingArgs(int position) {
        return SqlException.$(position, "missing arguments");
    }

    private boolean isCompletedOperand(int branchTag) {
        return branchTag == 6 || branchTag == 4 || branchTag == 18 || branchTag == 16 || branchTag == 3;
    }

    private boolean isCount() {
        return this.opStack.size() == 2 && Chars.equals(this.opStack.peek().token, '(') && SqlKeywords.isCountKeyword(this.opStack.peek((int)1).token);
    }

    private boolean isExtractFunctionOnStack() {
        boolean found = false;
        int n = this.opStack.size();
        for (int i = 0; i < n; ++i) {
            ExpressionNode peek = this.opStack.peek(i);
            if (!Chars.equals(peek.token, '(') || i + 1 >= n || !SqlKeywords.isExtractKeyword(this.opStack.peek((int)(i + 1)).token)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isTypeQualifier() {
        return this.opStack.size() >= 2 && SqlKeywords.isColonColon(this.opStack.peek((int)1).token);
    }

    private int onNode(ExpressionParserListener listener, ExpressionNode node, int argStackDepth, int prevBranch) throws SqlException {
        return this.onNode(listener, node, argStackDepth, prevBranch, false);
    }

    private int onNode(ExpressionParserListener listener, ExpressionNode node, int argStackDepth, int prevBranch, boolean exprStackUnwind) throws SqlException {
        if (node.type == 9 && Chars.equals(node.token, ':') && (argStackDepth == 1 || prevBranch == 5)) {
            node.paramCount = 1;
        }
        if (argStackDepth < node.paramCount) {
            throw SqlException.position(node.position).put("too few arguments for '").put(node.token).put("' [found=").put(argStackDepth).put(",expected=").put(node.paramCount).put(']');
        }
        if (node.type == 7) {
            if (exprStackUnwind) {
                SqlKeywords.assertNameIsQuotedOrNotAKeyword(node.token, node.position);
            }
            node.token = GenericLexer.unquote(node.token);
        }
        listener.onNode(node);
        return argStackDepth - node.paramCount + 1;
    }

    private int processLambdaQuery(GenericLexer lexer, ExpressionParserListener listener, int argStackDepth, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        this.opStack.push(this.expressionNodePool.next().of(5, "|", Integer.MAX_VALUE, lexer.lastTokenPosition()));
        int savedParamCountStackBottom = this.paramCountStack.bottom();
        this.paramCountStack.setBottom(this.paramCountStack.sizeRaw());
        int savedArgStackDepthStackBottom = this.argStackDepthStack.bottom();
        this.argStackDepthStack.setBottom(this.argStackDepthStack.sizeRaw());
        int pos = lexer.lastTokenPosition();
        lexer.unparseLast();
        ExpressionNode node = this.expressionNodePool.next().of(10, null, 0, pos);
        this.onNode(listener, node, argStackDepth, 0);
        node.queryModel = this.sqlParser.parseAsSubQuery(lexer, null, true, sqlParserCallback, decls);
        argStackDepth = this.onNode(listener, node, argStackDepth, 0);
        ExpressionNode control = this.opStack.peek();
        if (control != null && control.type == 5 && Chars.equals(control.token, '|')) {
            this.opStack.pop();
        }
        this.paramCountStack.setBottom(savedParamCountStackBottom);
        this.argStackDepthStack.setBottom(savedArgStackDepthStackBottom);
        return argStackDepth;
    }

    private boolean withinArrayConstructor() {
        int n = this.scopeStack.size();
        for (int i = 0; i < n; ++i) {
            if (this.scopeStack.peek(i) != Scope.ARRAY) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseExpr(GenericLexer lexer, ExpressionParserListener listener, SqlParserCallback sqlParserCallback, @Nullable LowerCaseCharSequenceObjHashMap<ExpressionNode> decls) throws SqlException {
        int savedScopeStackBottom = 0;
        try {
            ExpressionNode node;
            Object tok;
            int shadowParseMismatchFirstPosition = -1;
            int paramCount = 0;
            int betweenCount = 0;
            int betweenAndCount = 0;
            int caseCount = 0;
            int argStackDepth = 0;
            int betweenStartCaseCount = 0;
            savedScopeStackBottom = this.scopeStack.getBottom();
            this.scopeStack.setBottom(this.scopeStack.sizeRaw());
            boolean parsedDeclaration = false;
            int prevBranch = 0;
            int thisBranch = 0;
            boolean isCastingNull = false;
            block54: while ((tok = SqlUtil.fetchNext(lexer)) != null) {
                CharacterStoreEntry cse;
                char thisChar = tok.charAt(0);
                prevBranch = thisBranch;
                boolean processDefaultBranch = false;
                int lastPos = lexer.lastTokenPosition();
                block2 : switch (thisChar) {
                    case '+': 
                    case '-': {
                        char c;
                        processDefaultBranch = true;
                        if (prevBranch != 4 || lastPos <= 0 || (c = lexer.getContent().charAt(lastPos - 1)) != 'e' && c != 'E') break;
                        ExpressionNode en = this.opStack.peek();
                        ((GenericLexer.FloatingSequence)en.token).setHi(lastPos + 1);
                        processDefaultBranch = false;
                        break;
                    }
                    case '.': {
                        if (thisBranch == 6 || thisBranch == 4) {
                            char c = lexer.getContent().charAt(lastPos - 1);
                            if (GenericLexer.WHITESPACE_CH.contains(c)) {
                                lexer.unparseLast();
                                break block54;
                            }
                            if (Chars.isQuote(c)) {
                                ExpressionNode en = this.opStack.pop();
                                cse = this.characterStore.newEntry();
                                ((Utf16Sink)cse.put(GenericLexer.unquoteIfNoDots(en.token))).put('.');
                                this.opStack.push(this.expressionNodePool.next().of(7, cse.toImmutable(), Integer.MIN_VALUE, en.position));
                            } else {
                                ExpressionNode en = this.opStack.peek();
                                ((GenericLexer.FloatingSequence)en.token).setHi(lastPos + 1);
                            }
                        }
                        if (prevBranch == 12 || prevBranch == 17) {
                            throw SqlException.$(lastPos, "too many dots");
                        }
                        if (thisBranch == 10) {
                            throw SqlException.$(lastPos, "unexpected dot");
                        }
                        if (prevBranch == 3) {
                            thisBranch = 17;
                            break;
                        }
                        thisBranch = 12;
                        break;
                    }
                    case ',': {
                        if (prevBranch == 1 || prevBranch == 2 || prevBranch == 15) {
                            throw ExpressionParser.missingArgs(lastPos);
                        }
                        thisBranch = 1;
                        Scope scope0 = this.scopeStack.peek();
                        if (scope0 != Scope.PAREN && scope0 != Scope.BRACKET && scope0 != Scope.ARRAY) {
                            lexer.unparseLast();
                            break block54;
                        }
                        Scope scope1 = this.scopeStack.peek(1);
                        if (scope1 == Scope.CAST || scope1 == Scope.CAST_AS) {
                            throw SqlException.$(lastPos, "',' is not expected here");
                        }
                        while ((node = this.opStack.pop()) != null && node.type != 5) {
                            argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                        }
                        assert (node != null) : "opStack is empty at ','";
                        this.opStack.push(node);
                        ++paramCount;
                        break;
                    }
                    case ':': {
                        processDefaultBranch = true;
                        if (tok.length() > 1 || this.isCompletedOperand(prevBranch)) break;
                        CharSequence content = lexer.getContent();
                        int posAfterColon = lastPos + 1;
                        if (content.length() <= posAfterColon || Character.isWhitespace(content.charAt(posAfterColon))) break;
                        CharSequence nextToken = lexer.next();
                        tok = (String)tok + String.valueOf(nextToken);
                        break;
                    }
                    case '[': {
                        ExpressionNode other;
                        boolean isArrayConstructor;
                        ExpressionNode en = this.opStack.peek();
                        if (en != null && en.type == 7 && this.isTypeQualifier() || this.scopeStack.peek(1) == Scope.CAST_AS) {
                            if (lastPos > 0 && Character.isWhitespace(lexer.getContent().charAt(lastPos - 1))) {
                                int hi = Chars.indexOfNonWhitespace(lexer.getContent(), en.position, lastPos, -1);
                                if ($assertionsDisabled || hi != -1) throw SqlException.position(lastPos).put("array type requires no whitespace: expected '").put(lexer.getContent(), en.position, hi + 1).put("[]' but found '").put(lexer.getContent(), en.position, lastPos).put(" []'");
                                throw new AssertionError();
                            }
                            ((GenericLexer.FloatingSequence)en.token).setHi(lastPos + 1);
                            thisBranch = 20;
                            continue block54;
                        }
                        switch (prevBranch) {
                            case 5: {
                                if (en == null || !Chars.equals(en.token, (CharSequence)"::")) throw SqlException.position(lastPos).put("'[' is unexpected here");
                                tok = SqlUtil.fetchNext(lexer);
                                if (!Chars.equalsNc((CharSequence)tok, ']') || lastPos + 1 != lexer.lastTokenPosition() || (tok = SqlUtil.fetchNext(lexer)) == null || ColumnType.tagOf((CharSequence)tok) == -1) throw SqlException.position(lastPos).put("type definition is expected");
                                throw SqlException.position(lastPos).put("did you mean '").put((CharSequence)tok).put("[]'?");
                            }
                            case 2: 
                            case 4: 
                            case 7: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 14: 
                            case 18: {
                                throw SqlException.position(lastPos).put("'[' is unexpected here");
                            }
                        }
                        thisBranch = 15;
                        boolean bl = isArrayConstructor = this.withinArrayConstructor() && !this.isCompletedOperand(prevBranch);
                        while ((other = this.opStack.peek()) != null && (other.type == 7 || other.type == 2 || other.type == 1)) {
                            argStackDepth = this.onNode(listener, other, argStackDepth, prevBranch);
                            this.opStack.pop();
                        }
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.scopeStack.push(Scope.BRACKET);
                        this.opStack.push(this.expressionNodePool.next().of(5, isArrayConstructor ? "[[" : "[", Integer.MAX_VALUE, lastPos));
                        break;
                    }
                    case ']': {
                        switch (prevBranch) {
                            case 20: {
                                ExpressionNode en = this.opStack.peek();
                                assert (en != null && en.type == 7);
                                GenericLexer.FloatingSequence token = (GenericLexer.FloatingSequence)en.token;
                                assert (token.charAt(token.length() - 1) == '[');
                                if (lastPos - (en.position + en.token.length()) != 0) throw SqlException.position(lastPos).put("expected '").put(en.token).put("]' but found '").put(lexer.getContent(), en.position, lastPos + tok.length()).put('\'');
                                token.setHi(lastPos + 1);
                                thisBranch = 21;
                                break block2;
                            }
                            case 1: {
                                throw ExpressionParser.missingArgs(lastPos);
                            }
                            case 2: {
                                throw SqlException.$(lastPos, "syntax error");
                            }
                            case 5: {
                                ExpressionNode en = this.opStack.peek();
                                if (en != null && Chars.equals(en.token, ':')) break;
                                throw SqlException.$(lastPos, "syntax error");
                            }
                        }
                        Scope scope = this.scopeStack.peek();
                        if (scope != Scope.BRACKET && scope != Scope.ARRAY) {
                            lexer.unparseLast();
                            break block54;
                        }
                        this.scopeStack.pop();
                        int bracketArgCount = prevBranch == 15 ? 0 : paramCount + 1;
                        thisBranch = 16;
                        while ((node = this.opStack.pop()) != null && (node.type != 5 || node.token.charAt(0) != '[')) {
                            argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                        }
                        assert (node != null) : "opStack is empty at ']'";
                        if (Chars.equals(node.token, '[')) {
                            if (bracketArgCount == 0) {
                                throw SqlException.$(lastPos, "empty brackets");
                            }
                            node = this.expressionNodePool.next().of(1, "[]", 2, node.position);
                            node.paramCount = bracketArgCount + 1;
                            this.opStack.push(node);
                        } else {
                            assert (Chars.equals(node.token, (CharSequence)"[[")) : "token is neither '[' nor '[['";
                            node = this.expressionNodePool.next().of(2, "ARRAY", 2, node.position);
                            node.paramCount = bracketArgCount;
                            argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                        }
                        if (this.argStackDepthStack.notEmpty()) {
                            argStackDepth += this.argStackDepthStack.pop();
                        }
                        if (!this.paramCountStack.notEmpty()) break;
                        paramCount = this.paramCountStack.pop();
                        break;
                    }
                    case '(': {
                        if (parsedDeclaration && prevBranch != 2 && prevBranch != 6 && (prevBranch != 5 || !Chars.equals(this.opStack.peek().token, (CharSequence)":="))) {
                            lexer.unparseLast();
                            break block54;
                        }
                        if (prevBranch == 3) {
                            throw SqlException.$(lastPos, "not a function call");
                        }
                        if (prevBranch == 4) {
                            throw SqlException.$(lastPos, "dangling expression");
                        }
                        thisBranch = 2;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.scopeStack.push(Scope.PAREN);
                        this.opStack.push(this.expressionNodePool.next().of(5, "(", Integer.MAX_VALUE, lastPos));
                        break;
                    }
                    case ')': {
                        boolean thisWasCast;
                        int localParamCount;
                        switch (prevBranch) {
                            case 1: {
                                throw ExpressionParser.missingArgs(lastPos);
                            }
                            case 20: {
                                throw SqlException.$(lastPos, "']' expected");
                            }
                        }
                        if (this.scopeStack.peek() != Scope.PAREN) {
                            lexer.unparseLast();
                            break block54;
                        }
                        this.scopeStack.pop();
                        thisBranch = 3;
                        int n = localParamCount = prevBranch == 2 ? 0 : paramCount + 1;
                        if (this.scopeStack.peek() == Scope.CAST_AS) {
                            this.scopeStack.pop();
                            thisWasCast = true;
                        } else {
                            if (this.scopeStack.peek() == Scope.CAST) {
                                throw SqlException.$(lastPos, "'as' missing");
                            }
                            thisWasCast = false;
                        }
                        while ((node = this.opStack.pop()) != null && (node.type != 5 || node.token.charAt(0) != '(')) {
                            if (Chars.equals(node.token, '*') && argStackDepth == 0 && this.isCount()) {
                                argStackDepth = this.onNode(listener, node, 2, prevBranch);
                                continue;
                            }
                            if (thisWasCast && prevBranch != 18) {
                                short castAsTag = ColumnType.tagOf(node.token);
                                if (ExpressionParser.cannotCastTo(castAsTag, isCastingNull) || castAsTag == 23 && node.type == 7) {
                                    throw SqlException.$(node.position, "unsupported cast");
                                }
                                node.type = 4;
                            }
                            argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                        }
                        if (this.argStackDepthStack.notEmpty()) {
                            argStackDepth += this.argStackDepthStack.pop();
                        }
                        if (this.paramCountStack.notEmpty()) {
                            paramCount = this.paramCountStack.pop();
                        }
                        if ((node = this.opStack.peek()) == null) break;
                        if (localParamCount > 1 && node.token.charAt(0) == '(') {
                            if (this.opStack.size() <= 1) throw SqlException.$(lastPos, "no function or operator?");
                            ExpressionNode en = this.opStack.peek();
                            if (en.type != 5 || !Chars.equals(en.token, '(')) throw SqlException.$(lastPos, "no function or operator?");
                            en = this.opStack.peek(1);
                            if (en.type != 7 || !Chars.equals(en.token, (CharSequence)"count_distinct")) throw SqlException.$(lastPos, "no function or operator?");
                            throw SqlException.$(lastPos, "count distinct aggregation supports a single column only");
                        }
                        if (node.type == 7) {
                            node.paramCount = localParamCount + Math.max(0, node.paramCount - 1);
                            node.type = 6;
                            argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                            this.opStack.pop();
                            break;
                        }
                        if (node.type != 11 || SqlKeywords.isBetweenKeyword(node.token)) break;
                        node.paramCount = localParamCount + Math.max(0, node.paramCount - 1);
                        if (node.paramCount < 2) {
                            throw SqlException.position(node.position).put("too few arguments for '").put(node.token).put('\'');
                        }
                        node.type = 6;
                        argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                        this.opStack.pop();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (parsedDeclaration && prevBranch != 2 && SqlKeywords.isDeclareKeyword((CharSequence)tok)) {
                            lexer.unparseLast();
                            break block54;
                        }
                        if (prevBranch != 6 && SqlKeywords.isDeclareKeyword((CharSequence)tok)) {
                            thisBranch = 7;
                            if (betweenCount > 0) {
                                throw SqlException.$(lastPos, "constant expected");
                            }
                            argStackDepth = this.processLambdaQuery(lexer, listener, argStackDepth, sqlParserCallback, decls);
                            processDefaultBranch = false;
                            break;
                        }
                        if (prevBranch == 2 && SqlKeywords.isDistinctKeyword((CharSequence)tok) && this.opStack.size() > 1) {
                            ExpressionNode en = this.opStack.peek();
                            assert (Chars.equals(en.token, '(') && en.type == 5);
                            CharSequence tokenStash = GenericLexer.immutableOf((CharSequence)tok);
                            CharSequence nextToken = SqlUtil.fetchNext(lexer);
                            if (nextToken != null) {
                                if (Chars.equals(nextToken, ')') || Chars.equals(nextToken, ',') || Chars.equals(nextToken, (CharSequence)"::")) {
                                    SqlKeywords.assertNameIsQuotedOrNotAKeyword(tokenStash, lastPos);
                                } else {
                                    en = this.opStack.peek(1);
                                    if (en.type == 7) {
                                        if (SqlKeywords.isCountKeyword(en.token)) {
                                            if (Chars.equals(nextToken, '*')) {
                                                throw SqlException.$(lastPos, "count(distinct *) is not supported");
                                            }
                                            en.token = "count_distinct";
                                            lexer.unparseLast();
                                            continue block54;
                                        }
                                        if (Chars.equalsIgnoreCase("string_agg", en.token)) {
                                            en.token = "string_distinct_agg";
                                            lexer.unparseLast();
                                            continue block54;
                                        }
                                    }
                                }
                                lexer.unparseLast();
                            }
                            tok = tokenStash;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        if (SqlKeywords.isGeoHashKeyword((CharSequence)tok)) {
                            CharSequence geohashTok = GenericLexer.immutableOf((CharSequence)tok);
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null || tok.charAt(0) != '(') {
                                lexer.backTo(lastPos + 7, geohashTok);
                                tok = geohashTok;
                                processDefaultBranch = true;
                                break;
                            }
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null || tok.charAt(0) == ')') throw SqlException.$(lexer.lastTokenPosition(), "invalid GEOHASH, invalid type precision");
                            GeoHashUtil.parseGeoHashBits(lexer.lastTokenPosition(), 0, (CharSequence)tok);
                            this.opStack.push(this.expressionNodePool.next().of(4, lexer.immutablePairOf(geohashTok, (CharSequence)tok), Integer.MIN_VALUE, lastPos));
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null || tok.charAt(0) != ')') {
                                throw SqlException.$(lexer.lastTokenPosition(), "invalid GEOHASH, missing ')'");
                            }
                            thisBranch = 18;
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '#': {
                        if (ExpressionParser.isGeoHashCharsConstant((CharSequence)tok)) {
                            thisBranch = 4;
                            CharSequence geohashTok = GenericLexer.immutableOf((CharSequence)tok);
                            CharSequence slash = SqlUtil.fetchNext(lexer);
                            if (slash == null || slash.charAt(0) != '/') {
                                lexer.unparseLast();
                                this.opStack.push(this.expressionNodePool.next().of(4, geohashTok, Integer.MIN_VALUE, lastPos));
                                break;
                            }
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null || !Chars.isOnlyDecimals((CharSequence)tok)) {
                                throw SqlException.$(lexer.lastTokenPosition(), "missing bits size for GEOHASH constant");
                            }
                            this.opStack.push(this.expressionNodePool.next().of(4, lexer.immutablePairOf(geohashTok, '/', (CharSequence)tok), Integer.MIN_VALUE, lastPos));
                            break;
                        }
                        if (ExpressionParser.isGeoHashBitsConstant((CharSequence)tok)) {
                            thisBranch = 4;
                            this.opStack.push(this.expressionNodePool.next().of(4, GenericLexer.immutableOf((CharSequence)tok), Integer.MIN_VALUE, lastPos));
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (SqlKeywords.isCastKeyword((CharSequence)tok)) {
                            CharSequence castTok = GenericLexer.immutableOf((CharSequence)tok);
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null || tok.charAt(0) != '(') {
                                lexer.backTo(lastPos + 4, castTok);
                                tok = castTok;
                                processDefaultBranch = true;
                                break;
                            }
                            lexer.backTo(lastPos + 4, castTok);
                            tok = castTok;
                            if (prevBranch == 17) throw SqlException.$(lastPos, "'cast' is not allowed here");
                            this.scopeStack.push(Scope.CAST);
                            thisBranch = 5;
                            this.opStack.push(this.expressionNodePool.next().of(7, "cast", Integer.MIN_VALUE, lastPos));
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        if (SqlKeywords.isAsKeyword((CharSequence)tok)) {
                            if (this.scopeStack.peek(1) == Scope.CAST) {
                                thisBranch = 11;
                                int nodeCount = 0;
                                while ((node = this.opStack.pop()) != null && node.token.charAt(0) != '(') {
                                    isCastingNull = ++nodeCount == 1 && SqlKeywords.isNullKeyword(node.token);
                                    argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                ++paramCount;
                                this.scopeStack.update(1, Scope.CAST_AS);
                                break;
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        if (SqlKeywords.isAndKeyword((CharSequence)tok)) {
                            if (caseCount == betweenStartCaseCount && betweenCount > betweenAndCount) {
                                ++betweenAndCount;
                                thisBranch = 14;
                                while ((node = this.opStack.pop()) != null && !SqlKeywords.isBetweenKeyword(node.token)) {
                                    argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                                }
                                if (node == null) break;
                                this.opStack.push(node);
                                break;
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        if (SqlKeywords.isAllKeyword((CharSequence)tok)) {
                            ExpressionNode operator = this.opStack.peek();
                            if (operator == null || operator.type != 9) {
                                throw SqlException.$(lastPos, "missing operator");
                            }
                            CharSequence funcName = allFunctions.get(operator.token);
                            if (funcName == null || operator.paramCount != 2) throw SqlException.$(operator.position, "unexpected operator");
                            operator.type = 6;
                            operator.token = funcName;
                            break;
                        }
                        if (SqlKeywords.isArrayKeyword((CharSequence)tok)) {
                            CharSequence nextTok = SqlUtil.fetchNext(lexer);
                            if (nextTok == null || !Chars.equals(nextTok, (CharSequence)"[")) {
                                throw SqlException.$(lexer.lastTokenPosition(), "ARRAY not followed by '['");
                            }
                            thisBranch = 15;
                            this.paramCountStack.push(paramCount);
                            paramCount = 0;
                            this.argStackDepthStack.push(argStackDepth);
                            argStackDepth = 0;
                            this.scopeStack.push(Scope.ARRAY);
                            this.opStack.push(this.expressionNodePool.next().of(5, "[[", Integer.MAX_VALUE, lexer.lastTokenPosition()));
                            break;
                        }
                        if (this.isCompletedOperand(prevBranch) && SqlKeywords.isAtKeyword((CharSequence)tok)) {
                            int pos = lexer.getPosition();
                            CharSequence atTok = GenericLexer.immutableOf((CharSequence)tok);
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok != null && SqlKeywords.isTimeKeyword((CharSequence)tok)) {
                                tok = SqlUtil.fetchNext(lexer);
                                if (tok == null || !SqlKeywords.isZoneKeyword((CharSequence)tok)) throw SqlException.$(tok == null ? lexer.getPosition() : lexer.lastTokenPosition(), "did you mean 'at time zone <tz>'?");
                                thisBranch = 19;
                                break;
                            }
                            tok = atTok;
                            if (caseCount > 0 || nonLiteralBranches.excludes(thisBranch)) {
                                lexer.unparseLast();
                            } else {
                                lexer.unparse((CharSequence)tok, lastPos, pos);
                            }
                            processDefaultBranch = true;
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        if (SqlKeywords.isBetweenKeyword((CharSequence)tok)) {
                            thisBranch = 13;
                            if (betweenCount > betweenAndCount) {
                                throw SqlException.$(lastPos, "between statements cannot be nested");
                            }
                            ++betweenCount;
                            betweenStartCaseCount = caseCount;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (parsedDeclaration && prevBranch != 2 && SqlKeywords.isSelectKeyword((CharSequence)tok)) {
                            lexer.unparseLast();
                            break block54;
                        }
                        if (prevBranch != 6 && SqlKeywords.isSelectKeyword((CharSequence)tok)) {
                            thisBranch = 7;
                            if (betweenCount > 0) {
                                throw SqlException.$(lastPos, "constant expected");
                            }
                            argStackDepth = this.processLambdaQuery(lexer, listener, argStackDepth, sqlParserCallback, decls);
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '\'': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'E': {
                        char prevChar;
                        switch (prevBranch) {
                            case 17: {
                                throw SqlException.$(lastPos, "constant is not allowed here");
                            }
                            case 20: {
                                throw SqlException.$(lastPos, "']' expected");
                            }
                        }
                        if (thisChar == 'E' && (tok.length() < 3 || tok.charAt(1) != '\'')) {
                            processDefaultBranch = true;
                            break;
                        }
                        thisBranch = 4;
                        if (prevBranch == 4 && lastPos > 0 && ((prevChar = lexer.getContent().charAt(lastPos - 1)) == '-' || prevChar == '+')) {
                            ExpressionNode en = this.opStack.peek();
                            if (en.token instanceof GenericLexer.FloatingSequence) {
                                ((GenericLexer.FloatingSequence)en.token).setHi(lexer.getTokenHi());
                                break;
                            }
                            assert (false);
                        }
                        if (prevBranch == 12) {
                            ExpressionNode en = this.opStack.peek();
                            if (en != null && en.type != 5 && en.type != 9) {
                                if (lastPos > 0 && lexer.getContent().charAt(lastPos - 1) == '.') {
                                    if (en.token instanceof GenericLexer.FloatingSequence) {
                                        ((GenericLexer.FloatingSequence)en.token).setHi(lexer.getTokenHi());
                                        break;
                                    }
                                    this.opStack.pop();
                                    CharacterStoreEntry cse2 = this.characterStore.newEntry();
                                    ((Utf16Sink)cse2.put(en.token)).put(GenericLexer.unquote((CharSequence)tok));
                                    CharSequence lit = cse2.toImmutable();
                                    SqlKeywords.assertNameIsQuotedOrNotAKeyword(lit, en.position);
                                    this.opStack.push(this.expressionNodePool.next().of(7, lit, Integer.MIN_VALUE, en.position));
                                    break;
                                }
                            } else {
                                this.opStack.push(SqlUtil.nextConstant(this.expressionNodePool, lexer.immutableBetween(lastPos - 1, lexer.getTokenHi()), lastPos));
                                break;
                            }
                        }
                        if (prevBranch != 12 && nonLiteralBranches.excludes(prevBranch)) {
                            if (SqlKeywords.isQuote((CharSequence)tok)) {
                                throw SqlException.$(lastPos, "unclosed quoted string?");
                            }
                            ExpressionNode constNode = SqlUtil.nextConstant(this.expressionNodePool, GenericLexer.immutableOf((CharSequence)tok), lastPos);
                            if (prevBranch == 19) {
                                argStackDepth = this.onNode(listener, constNode, argStackDepth, prevBranch);
                                constNode = this.expressionNodePool.next().of(6, "to_timezone", Integer.MIN_VALUE, lastPos);
                                constNode.paramCount = 2;
                            }
                            this.opStack.push(constNode);
                            break;
                        }
                        if (this.opStack.size() > 0 && prevBranch == 6 && thisChar == '\'') {
                            ExpressionNode prevNode = this.opStack.pop();
                            short columnType = ColumnType.tagOf(prevNode.token);
                            if (ExpressionParser.cannotCastTo(columnType, isCastingNull)) {
                                throw SqlException.$(prevNode.position, "impossible type cast, invalid type");
                            }
                            ExpressionNode stringLiteral = SqlUtil.nextConstant(this.expressionNodePool, GenericLexer.immutableOf((CharSequence)tok), lastPos);
                            this.onNode(listener, stringLiteral, 0, prevBranch);
                            prevNode.type = 4;
                            this.onNode(listener, prevNode, 0, prevBranch);
                            ExpressionNode cast = this.expressionNodePool.next().of(6, "cast", 0, prevNode.position);
                            cast.paramCount = 2;
                            this.onNode(listener, cast, argStackDepth + 2, prevBranch);
                            ++argStackDepth;
                            break;
                        }
                        if (this.opStack.size() > 1) {
                            throw SqlException.$(lastPos, "dangling expression");
                        }
                        lexer.unparseLast();
                        break block54;
                    }
                    case 'F': 
                    case 'N': 
                    case 'T': 
                    case 'f': 
                    case 'n': 
                    case 't': {
                        if (prevBranch == 20) {
                            throw SqlException.$(lastPos, "']' expected");
                        }
                        if (SqlKeywords.isNanKeyword((CharSequence)tok) || SqlKeywords.isNullKeyword((CharSequence)tok) || SqlKeywords.isTrueKeyword((CharSequence)tok) || SqlKeywords.isFalseKeyword((CharSequence)tok)) {
                            if (prevBranch == 17) throw SqlException.$(lastPos, "constant is not allowed here");
                            if (!nonLiteralBranches.excludes(prevBranch)) throw SqlException.$(lastPos, "dangling expression");
                            thisBranch = 4;
                            this.opStack.push(SqlUtil.nextConstant(this.expressionNodePool, GenericLexer.immutableOf((CharSequence)tok), lastPos));
                            break;
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (SqlKeywords.isIsKeyword((CharSequence)tok)) {
                            if (prevBranch != 6 && prevBranch != 4 && prevBranch != 3) throw SqlException.$(lastPos, "IS [NOT] not allowed here");
                            CharSequence isTok = GenericLexer.immutableOf((CharSequence)tok);
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok == null) {
                                throw SqlException.$(lastPos, "IS must be followed by [NOT] NULL, TRUE or FALSE");
                            }
                            if (SqlKeywords.isNotKeyword((CharSequence)tok)) {
                                int notTokPosition = lexer.lastTokenPosition();
                                CharSequence notTok = GenericLexer.immutableOf((CharSequence)tok);
                                tok = SqlUtil.fetchNext(lexer);
                                if (tok == null || !SqlKeywords.isNullKeyword((CharSequence)tok) && !SqlKeywords.isTrueKeyword((CharSequence)tok) && !SqlKeywords.isFalseKeyword((CharSequence)tok)) throw SqlException.$(lastPos, "IS NOT must be followed by NULL, TRUE or FALSE");
                                lexer.backTo(notTokPosition + 3, notTok);
                                tok = "!=";
                            } else {
                                if (!SqlKeywords.isNullKeyword((CharSequence)tok) && !SqlKeywords.isTrueKeyword((CharSequence)tok) && !SqlKeywords.isFalseKeyword((CharSequence)tok)) throw SqlException.$(lastPos, "IS must be followed by NULL, TRUE or FALSE");
                                lexer.backTo(lastPos + 2, isTok);
                                tok = "=";
                            }
                        }
                        processDefaultBranch = true;
                        break;
                    }
                    case '*': {
                        if (prevBranch == 12) {
                            thisBranch = 6;
                            ExpressionNode en = this.opStack.peek();
                            if (en != null && en.type != 5) {
                                if (en.token instanceof GenericLexer.FloatingSequence) {
                                    GenericLexer.FloatingSequence fs = (GenericLexer.FloatingSequence)en.token;
                                    fs.setHi(lastPos + 1);
                                    break;
                                }
                                this.opStack.pop();
                                CharacterStoreEntry cse3 = this.characterStore.newEntry();
                                ((Utf16Sink)cse3.put(en.token)).put('*');
                                this.opStack.push(this.expressionNodePool.next().of(7, cse3.toImmutable(), Integer.MIN_VALUE, en.position));
                                break;
                            }
                            this.opStack.push(this.expressionNodePool.next().of(4, lexer.immutableBetween(lastPos - 1, lexer.getTokenHi()), 0, lastPos));
                            break;
                        }
                    }
                    default: {
                        if (prevBranch == 20) {
                            throw SqlException.$(lastPos, "']' expected");
                        }
                        processDefaultBranch = true;
                    }
                }
                if (!processDefaultBranch) continue;
                OperatorExpression op = this.activeRegistry.map.get((CharSequence)tok);
                if (op != null) {
                    ExpressionNode other;
                    boolean unaryOperator;
                    thisBranch = 5;
                    if (Chars.equals((CharSequence)tok, (CharSequence)":=")) {
                        parsedDeclaration = true;
                    }
                    if (thisChar == '-' || thisChar == '~') {
                        assert (prevBranch != 13);
                        switch (prevBranch) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 5: 
                            case 10: 
                            case 14: 
                            case 15: {
                                if (thisChar == '-') {
                                    op = this.activeRegistry.unaryMinus;
                                }
                                if (thisChar != '~') break;
                                op = this.activeRegistry.unaryComplement;
                                break;
                            }
                        }
                    }
                    int operatorType = op.type;
                    boolean bl = unaryOperator = op.type == 1;
                    if (SqlKeywords.isNotKeyword((CharSequence)tok)) {
                        OperatorExpression nextOp;
                        int lastTokenPosition = lexer.lastTokenPosition();
                        CharSequence lastToken = GenericLexer.immutableOf((CharSequence)tok);
                        CharSequence nextToken = SqlUtil.fetchNext(lexer);
                        if (nextToken != null && (nextOp = this.activeRegistry.map.get(nextToken)) != null && nextOp.type == 3) {
                            op = this.activeRegistry.unarySetNegation;
                            unaryOperator = false;
                        }
                        lexer.backTo(lastTokenPosition + lastToken.length(), lastToken);
                    }
                    while ((other = this.opStack.peek()) != null) {
                        boolean greaterPrecedence = op.greaterPrecedence(other.precedence);
                        if (unaryOperator && other.paramCount > 0) break;
                        if (this.shadowRegistry != null) {
                            OperatorExpression shadowOther;
                            OperatorExpression activeOtherGuess = this.activeRegistry.tryGuessOperator(other.token, other.precedence);
                            OperatorExpression shadowOp = this.shadowRegistry.tryGetOperator(op.operator);
                            if (shadowOp != null && activeOtherGuess != null && (shadowOther = this.shadowRegistry.tryGetOperator(activeOtherGuess.operator)) != null && greaterPrecedence != shadowOp.greaterPrecedence(shadowOther.precedence)) {
                                shadowParseMismatchFirstPosition = lexer.lastTokenPosition();
                            }
                        }
                        if (!greaterPrecedence) break;
                        argStackDepth = this.onNode(listener, other, argStackDepth, prevBranch);
                        this.opStack.pop();
                    }
                    node = this.expressionNodePool.next().of(op.type == 3 ? 11 : 9, op.operator.token, op.precedence, lastPos);
                    node.paramCount = operatorType == 1 ? 1 : (SqlKeywords.isBetweenKeyword(node.token) ? 3 : 2);
                    this.opStack.push(node);
                    continue;
                }
                if (caseCount > 0 || nonLiteralBranches.excludes(thisBranch)) {
                    if (Chars.toLowerCaseAscii(thisChar) == 'c' && SqlKeywords.isCaseKeyword((CharSequence)tok)) {
                        if (prevBranch == 17) {
                            throw SqlException.$(lastPos, "'case' is not allowed here");
                        }
                        ++caseCount;
                        this.paramCountStack.push(paramCount);
                        paramCount = 0;
                        this.argStackDepthStack.push(argStackDepth);
                        argStackDepth = 0;
                        this.scopeStack.push(Scope.CASE);
                        this.opStack.push(this.expressionNodePool.next().of(6, "case", Integer.MAX_VALUE, lastPos));
                        thisBranch = 9;
                        continue;
                    }
                    thisBranch = 6;
                    if (caseCount > 0) {
                        switch (Chars.toLowerCaseAscii(thisChar)) {
                            case 'e': {
                                if (SqlKeywords.isEndKeyword((CharSequence)tok)) {
                                    if (prevBranch == 10) {
                                        throw ExpressionParser.missingArgs(lastPos);
                                    }
                                    if (paramCount == 0) {
                                        throw SqlException.$(lastPos, "'when' expected");
                                    }
                                    if (paramCount <= 2) {
                                        throw SqlException.$(lastPos, "'then' expected");
                                    }
                                    while ((node = this.opStack.pop()) != null && !SqlKeywords.isCaseKeyword(node.token)) {
                                        argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                                    }
                                    if (this.argStackDepthStack.notEmpty()) {
                                        argStackDepth += this.argStackDepthStack.pop();
                                    }
                                    Scope scope = this.scopeStack.pop();
                                    assert (scope == Scope.CASE) : "Should have popped CASE, but got " + String.valueOf((Object)scope);
                                    node.paramCount = paramCount;
                                    argStackDepth = this.onNode(listener, node, argStackDepth + paramCount, prevBranch);
                                    if (this.paramCountStack.notEmpty()) {
                                        paramCount = this.paramCountStack.pop();
                                    }
                                    --caseCount;
                                    continue block54;
                                }
                            }
                            case 't': 
                            case 'w': {
                                int keywordIndex = caseKeywords.get((CharSequence)tok);
                                if (keywordIndex <= -1) break;
                                if (prevBranch == 10) {
                                    throw ExpressionParser.missingArgs(lastPos);
                                }
                                if (keywordIndex == 2 && paramCount == 0) {
                                    throw SqlException.$(lastPos, "'when' expected");
                                }
                                int argCount = 0;
                                while ((node = this.opStack.pop()) != null && !SqlKeywords.isCaseKeyword(node.token)) {
                                    argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch);
                                    ++argCount;
                                }
                                if (paramCount == 0) {
                                    if (argCount == 0) {
                                        this.onNode(listener, this.expressionNodePool.next().of(7, null, Integer.MIN_VALUE, -1), argStackDepth, prevBranch);
                                    }
                                    ++paramCount;
                                }
                                switch (keywordIndex) {
                                    case 0: 
                                    case 2: {
                                        if (paramCount % 2 != 0) break;
                                        throw SqlException.$(lastPos, "'then' expected");
                                    }
                                    default: {
                                        if (paramCount % 2 == 0) break;
                                        throw SqlException.$(lastPos, "'when' expected");
                                    }
                                }
                                if (node != null) {
                                    this.opStack.push(node);
                                }
                                argStackDepth = 0;
                                ++paramCount;
                                thisBranch = 10;
                                continue block54;
                            }
                        }
                    }
                    if (prevBranch == 12) {
                        ExpressionNode en = this.opStack.peek();
                        if (en == null) {
                            throw SqlException.$(lastPos, "qualifier expected");
                        }
                        if (GenericLexer.WHITESPACE_CH.contains(lexer.getContent().charAt(lastPos - 1))) {
                            lexer.unparseLast();
                            break;
                        }
                        SqlKeywords.assertNameIsQuotedOrNotAKeyword((CharSequence)tok, lastPos);
                        if (Chars.isQuoted((CharSequence)tok) || en.token instanceof CharacterStore.NameAssemblerCharSequence) {
                            this.opStack.pop();
                            cse = this.characterStore.newEntry();
                            SqlKeywords.assertNameIsQuotedOrNotAKeyword((CharSequence)tok, en.position);
                            ((Utf16Sink)cse.put(en.token)).put(GenericLexer.unquoteIfNoDots((CharSequence)tok));
                            this.opStack.push(this.expressionNodePool.next().of(7, cse.toImmutable(), Integer.MIN_VALUE, en.position));
                            continue;
                        }
                        GenericLexer.FloatingSequence fsA = (GenericLexer.FloatingSequence)en.token;
                        fsA.setHi(lexer.getTokenHi());
                        continue;
                    }
                    if (prevBranch == 17) {
                        ++argStackDepth;
                        ExpressionNode dotDereference = this.expressionNodePool.next().of(9, this.activeRegistry.dot.operator.token, this.activeRegistry.dot.precedence, lastPos);
                        dotDereference.paramCount = 2;
                        this.opStack.push(dotDereference);
                        this.opStack.push(this.expressionNodePool.next().of(8, GenericLexer.immutableOf((CharSequence)tok), Integer.MIN_VALUE, lastPos));
                        continue;
                    }
                    if (SqlKeywords.isFromKeyword((CharSequence)tok) && this.opStack.size() > 1 && SqlKeywords.isExtractKeyword(this.opStack.peek((int)1).token)) {
                        if (paramCount != 0) throw SqlException.$(lastPos, "Unnecessary `from`. Typo?");
                        throw SqlException.$(lastPos, "Huh? What would you like to extract?");
                    }
                    if (SqlKeywords.isOverKeyword((CharSequence)tok)) {
                        if (Chars.equals(SqlUtil.fetchNext(lexer), '(')) {
                            throw SqlException.$(lastPos, "Nested window functions are not currently supported.");
                        }
                        lexer.unparseLast();
                    }
                    this.opStack.push(this.expressionNodePool.next().of(7, GenericLexer.immutableOf((CharSequence)tok), Integer.MIN_VALUE, lastPos));
                    continue;
                }
                ExpressionNode last = this.opStack.peek();
                if (last != null) {
                    if (SqlKeywords.isTimestampKeyword(last.token) && SqlKeywords.isWithKeyword((CharSequence)tok)) {
                        CharSequence withTok = GenericLexer.immutableOf((CharSequence)tok);
                        int withTokPosition = lexer.getPosition();
                        tok = SqlUtil.fetchNext(lexer);
                        if (tok != null && SqlKeywords.isTimeKeyword((CharSequence)tok) && (tok = SqlUtil.fetchNext(lexer)) != null && SqlKeywords.isZoneKeyword((CharSequence)tok)) {
                            CharSequence zoneTok = GenericLexer.immutableOf((CharSequence)tok);
                            int zoneTokPosition = lexer.getTokenHi();
                            tok = SqlUtil.fetchNext(lexer);
                            if (tok != null && (this.scopeStack.peek(1) == Scope.CAST_AS || tok.charAt(0) == '\'')) {
                                lexer.backTo(zoneTokPosition, zoneTok);
                                continue;
                            }
                            if (this.opStack.size() <= 1) throw SqlException.$(zoneTokPosition, "String literal expected after 'timestamp with time zone'");
                            ExpressionNode en = this.opStack.peek(1);
                            if (!SqlKeywords.isColonColon(en.token)) throw SqlException.$(zoneTokPosition, "String literal expected after 'timestamp with time zone'");
                            lexer.backTo(zoneTokPosition, zoneTok);
                            continue;
                        }
                        lexer.backTo(withTokPosition, withTok);
                    } else if (SqlKeywords.isFromKeyword((CharSequence)tok)) {
                        if (this.opStack.size() > 2) {
                            boolean extractError = true;
                            ExpressionNode member = this.opStack.peek(0);
                            if ((member.type == 7 || member.type == 4) && Chars.equals(this.opStack.peek((int)1).token, '(')) {
                                if (SqlKeywords.isExtractKeyword(this.opStack.peek((int)2).token)) {
                                    if (!SqlKeywords.validateExtractPart(GenericLexer.unquote(member.token))) throw SqlException.$(member.position, "unsupported timestamp part: ").put(member.token);
                                    member.type = 8;
                                    argStackDepth = this.onNode(listener, member, argStackDepth, prevBranch);
                                    this.opStack.pop();
                                    ++paramCount;
                                    thisBranch = 1;
                                    continue;
                                }
                                extractError = false;
                            }
                            if (extractError && this.isExtractFunctionOnStack()) {
                                throw SqlException.$(member.position, "we expect timestamp part here");
                            }
                        }
                    } else if (SqlKeywords.isOrderKeyword((CharSequence)tok) && this.opStack.size() > 2) {
                        ExpressionNode en = this.opStack.peek();
                        if (en.type == 4) {
                            en = this.opStack.peek(1);
                            if (en.type == 5 && Chars.equals(en.token, '(')) {
                                en = this.opStack.peek(2);
                                if (en.type == 7 && Chars.equalsIgnoreCase(en.token, "string_distinct_agg")) {
                                    throw SqlException.$(lastPos, "ORDER BY not supported for string_distinct_agg");
                                }
                            }
                        }
                    } else {
                        if (SqlKeywords.isDoubleKeyword(last.token) && SqlKeywords.isPrecisionKeyword((CharSequence)tok)) continue;
                        if (SqlKeywords.isOverKeyword((CharSequence)tok)) {
                            if (Chars.equals(SqlUtil.fetchNext(lexer), '(')) {
                                throw SqlException.$(lastPos, "Nested window functions' context are not currently supported.");
                            }
                            lexer.unparseLast();
                        }
                    }
                }
                if (this.scopeStack.notEmpty()) {
                    throw SqlException.$(lastPos, "dangling literal");
                }
                lexer.unparseLast();
                break;
            }
            if (thisBranch == 19) {
                throw SqlException.$(lexer.lastTokenPosition(), "did you mean 'at time zone <tz>'?");
            }
            while ((node = this.opStack.pop()) != null) {
                if (node.token.length() != 0 && node.token.charAt(0) == '(') {
                    throw SqlException.$(node.position, "unbalanced (");
                }
                if (node.type == 5 && node.token.charAt(0) == '[') {
                    throw SqlException.$(node.position, "unbalanced [");
                }
                if (SqlKeywords.isCaseKeyword(node.token)) {
                    throw SqlException.$(node.position, "unbalanced 'case'");
                }
                if (node.type == 5) {
                    this.opStack.push(node);
                    break;
                }
                argStackDepth = this.onNode(listener, node, argStackDepth, prevBranch, caseCount == 0);
            }
            if (shadowParseMismatchFirstPosition == -1) return;
            LOG.advisory().$("operator precedence compat mode: detected expression parsing behaviour change for query=[").$(lexer.getContent()).$("] at position=").$(shadowParseMismatchFirstPosition).$();
            return;
        }
        catch (SqlException e) {
            this.opStack.clear();
            this.scopeStack.clear();
            this.argStackDepthStack.clear();
            this.paramCountStack.clear();
            throw e;
        }
        finally {
            this.scopeStack.setBottom(savedScopeStackBottom);
            this.argStackDepthStack.popAll();
            this.paramCountStack.popAll();
        }
    }

    static {
        nonLiteralBranches.add(3);
        nonLiteralBranches.add(16);
        nonLiteralBranches.add(4);
        nonLiteralBranches.add(6);
        nonLiteralBranches.add(7);
        nonLiteralBranches.add(21);
        caseKeywords.put("when", 0);
        caseKeywords.put("then", 1);
        caseKeywords.put("else", 2);
        moreCastTargetTypes.add(19);
        moreCastTargetTypes.add(25);
        moreCastTargetTypes.add(26);
        moreCastTargetTypes.add(27);
        allFunctions.put("<>", "<>all");
        allFunctions.put("!=", "<>all");
    }

    private static enum Scope {
        CASE,
        CAST,
        CAST_AS,
        PAREN,
        BRACKET,
        ARRAY;

    }
}

