/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnType;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlException
extends Exception
implements Sinkable,
FlyweightMessageContainer {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final int EXCEPTION_TABLE_DOES_NOT_EXIST = -105;
    private static final int EXCEPTION_MAT_VIEW_DOES_NOT_EXIST = -106;
    private static final int EXCEPTION_WAL_RECOVERABLE = -107;
    private static final ThreadLocal<SqlException> tlException = new ThreadLocal<SqlException>(SqlException::new);
    private final StringSink message = new StringSink();
    private int error;
    private int position;

    protected SqlException() {
    }

    public static SqlException $(int position, CharSequence message) {
        return SqlException.position(position).put(message);
    }

    public static SqlException $(int position, long addrLo, long addrHi) {
        return SqlException.position(position).put(addrLo, addrHi);
    }

    public static SqlException ambiguousColumn(int position, CharSequence columnName) {
        return SqlException.position(position).put("Ambiguous column [name=").put(columnName).put(']');
    }

    public static SqlException duplicateColumn(int position, CharSequence colName) {
        return SqlException.duplicateColumn(position, colName, null);
    }

    public static SqlException duplicateColumn(int position, CharSequence colName, CharSequence additionalMessage) {
        SqlException exception = SqlException.$(position, "Duplicate column [name=").put(colName).put(']');
        if (additionalMessage != null) {
            exception.put(' ').put(additionalMessage);
        }
        return exception;
    }

    public static SqlException emptyWindowContext(int position) {
        return SqlException.$(position, "window function called in non-window context, make sure to add OVER clause");
    }

    public static SqlException inconvertibleTypes(int position, int fromType, CharSequence fromName, int toType, CharSequence toName) {
        return SqlException.$(position, "inconvertible types: ").put(ColumnType.nameOf(fromType)).put(" -> ").put(ColumnType.nameOf(toType)).put(" [from=").put(fromName).put(", to=").put(toName).put(']');
    }

    public static SqlException invalidColumn(int position, CharSequence column) {
        return SqlException.position(position).put("Invalid column: ").put(column);
    }

    public static SqlException invalidDate(CharSequence str, int position) {
        return SqlException.position(position).put("Invalid date [str=").put(str).put(']');
    }

    public static SqlException invalidDate(int position) {
        return SqlException.position(position).put("Invalid date");
    }

    public static SqlException matViewDoesNotExist(int position, CharSequence tableName) {
        return SqlException.position(position).errorCode(-106).put("materialized view does not exist [view=").put(tableName).put(']');
    }

    public static SqlException nonDeterministicColumn(int position, CharSequence column) {
        return SqlException.position(position).put("non-deterministic function cannot be used in materialized view: ").put(column);
    }

    public static SqlException parserErr(int position, @Nullable CharSequence tok, @NotNull CharSequence msg) {
        return tok == null ? SqlException.$(position, msg) : SqlException.$(position, "found [tok='").put(tok).put("', len=").put(tok.length()).put("] ").put(msg);
    }

    public static SqlException position(int position) {
        SqlException ex = tlException.get();
        assert ((ex = new SqlException()) != null);
        ex.message.clear();
        ex.position = position;
        ex.error = 0;
        return ex;
    }

    public static SqlException tableDoesNotExist(int position, CharSequence tableName) {
        return SqlException.position(position).errorCode(-105).put("table does not exist [table=").put(tableName).put(']');
    }

    public static SqlException unexpectedToken(int position, CharSequence token) {
        return SqlException.position(position).put("unexpected token [").put(token).put(']');
    }

    public static SqlException unexpectedToken(int position, CharSequence token, @NotNull CharSequence extraMessage) {
        return SqlException.position(position).put("unexpected token [").put(token).put("] - ").put(extraMessage);
    }

    public static SqlException unsupportedCast(int position, CharSequence columnName, int fromType, int toType) {
        return SqlException.$(position, "unsupported cast [column=").put(columnName).put(", from=").put(ColumnType.nameOf(fromType)).put(", to=").put(ColumnType.nameOf(toType)).put(']');
    }

    public static SqlException walRecoverable(int position) {
        return SqlException.position(position).errorCode(-107);
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return "[" + this.position + "] " + String.valueOf(this.message);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] result = EMPTY_STACK_TRACE;
        assert ((result = super.getStackTrace()) != null);
        return result;
    }

    public boolean isTableDoesNotExist() {
        return this.error == -105;
    }

    public boolean isWalRecoverable() {
        return this.error == -107;
    }

    public SqlException put(@Nullable CharSequence cs) {
        if (cs != null) {
            this.message.put(cs);
        }
        return this;
    }

    public SqlException put(@Nullable CharSequence cs, int lo, int hi) {
        if (cs != null) {
            this.message.put(cs, lo, hi);
        }
        return this;
    }

    public SqlException put(@Nullable Utf8Sequence cs) {
        if (cs != null) {
            this.message.put(cs);
        }
        return this;
    }

    public SqlException put(char c) {
        this.message.put(c);
        return this;
    }

    public SqlException put(int value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(long value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(double value) {
        this.message.put(value);
        return this;
    }

    public SqlException put(Sinkable sinkable) {
        this.message.put(sinkable);
        return this;
    }

    public SqlException put(long addrLo, long addrHi) {
        this.message.put(addrLo, addrHi);
        return this;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('[').put(this.position).putAscii("]: ").put(this.message);
    }

    private SqlException errorCode(int errorCode) {
        this.error = errorCode;
        return this;
    }
}

