/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlHints {
    public static final String ASOF_JOIN_AVOID_BINARY_SEARCH_HINT = "avoid_asof_binary_search";
    public static final char HINTS_PARAMS_DELIMITER = ' ';
    public static final String LT_JOIN_AVOID_BINARY_SEARCH_HINT = "avoid_lt_binary_search";

    public static boolean hasAvoidAsOfJoinBinarySearchHint(@NotNull QueryModel queryModel, @Nullable CharSequence tableNameA, @Nullable CharSequence tableNameB) {
        return SqlHints.hasHintWithParams(queryModel, ASOF_JOIN_AVOID_BINARY_SEARCH_HINT, tableNameA, tableNameB);
    }

    public static boolean hasAvoidLtJoinBinarySearchHint(@NotNull QueryModel queryModel, @Nullable CharSequence tableNameA, @Nullable CharSequence tableNameB) {
        return SqlHints.hasHintWithParams(queryModel, LT_JOIN_AVOID_BINARY_SEARCH_HINT, tableNameA, tableNameB);
    }

    private static boolean hasHintWithParams(@NotNull QueryModel queryModel, @NotNull CharSequence hintName, @Nullable CharSequence tableNameA, @Nullable CharSequence tableNameB) {
        LowerCaseCharSequenceObjHashMap<CharSequence> hints = queryModel.getHints();
        CharSequence params = hints.get(hintName);
        return Chars.containsWordIgnoreCase(params, tableNameA, ' ') && Chars.containsWordIgnoreCase(params, tableNameB, ' ');
    }
}

