/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.activity;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.QueryRegistry;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.ObjList;

public class QueryActivityFunctionFactory
implements FunctionFactory {
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "query_activity()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new QueryActivityCursorFactory(METADATA, sqlExecutionContext));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("query_id", 6));
        metadata.add(new TableColumnMetadata("worker_id", 6));
        metadata.add(new TableColumnMetadata("worker_pool", 11));
        metadata.add(new TableColumnMetadata("username", 11));
        metadata.add(new TableColumnMetadata("query_start", 8));
        metadata.add(new TableColumnMetadata("state_change", 8));
        metadata.add(new TableColumnMetadata("state", 11));
        metadata.add(new TableColumnMetadata("is_wal", 1));
        metadata.add(new TableColumnMetadata("query", 11));
        METADATA = metadata;
    }

    private static class QueryActivityCursorFactory
    extends AbstractRecordCursorFactory {
        private final QueryActivityCursor cursor;

        public QueryActivityCursorFactory(RecordMetadata metadata, SqlExecutionContext sqlExecutionContext) {
            super(metadata);
            this.cursor = new QueryActivityCursor(sqlExecutionContext);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.of(executionContext);
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(QueryActivityFunctionFactory.SIGNATURE);
        }
    }

    private static class QueryActivityCursor
    implements NoRandomAccessRecordCursor {
        private final LongList entryIds = new LongList();
        private final QueryRegistry queryRegistry;
        private final QueryActivityRecord record = new QueryActivityRecord();
        private QueryRegistry.Entry entry;
        private int entryIndex;
        private boolean isAdmin;
        private CharSequence principal;

        private QueryActivityCursor(SqlExecutionContext executionContext) {
            this.queryRegistry = executionContext.getCairoEngine().getQueryRegistry();
        }

        @Override
        public void close() {
            this.entryIds.clear();
            this.isAdmin = false;
            this.principal = null;
            this.toTop();
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() throws DataUnavailableException {
            while (++this.entryIndex < this.entryIds.size()) {
                this.entry = this.queryRegistry.getEntry(this.entryIds.get(this.entryIndex));
                if (this.entry == null || !this.isAdmin && !this.entry.getPrincipal().equals(this.principal)) continue;
                return true;
            }
            return false;
        }

        public void of(SqlExecutionContext executionContext) {
            try {
                executionContext.getSecurityContext().authorizeSqlEngineAdmin();
                this.isAdmin = true;
            }
            catch (CairoException e) {
                this.isAdmin = false;
                this.principal = executionContext.getSecurityContext().getPrincipal();
            }
            this.queryRegistry.getEntryIds(this.entryIds);
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() throws DataUnavailableException {
            return -1L;
        }

        @Override
        public void toTop() {
            this.entryIndex = -1;
            this.entry = null;
        }

        private class QueryActivityRecord
        implements Record {
            private QueryActivityRecord() {
            }

            @Override
            public boolean getBool(int col) {
                if (col == 7) {
                    return QueryActivityCursor.this.entry.isWAL();
                }
                return false;
            }

            @Override
            public long getLong(int col) {
                if (col == 0) {
                    return QueryActivityCursor.this.entryIds.getQuick(QueryActivityCursor.this.entryIndex);
                }
                if (col == 1) {
                    return QueryActivityCursor.this.entry.getWorkerId();
                }
                return Record.super.getLong(col);
            }

            @Override
            public CharSequence getStrA(int col) {
                if (col == 2) {
                    return QueryActivityCursor.this.entry.getPoolName();
                }
                if (col == 3) {
                    return QueryActivityCursor.this.entry.getPrincipal();
                }
                if (col == 6) {
                    return QueryActivityCursor.this.entry.getStateText();
                }
                if (col == 8) {
                    return QueryActivityCursor.this.entry.getQuery();
                }
                return Record.super.getStrA(col);
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }

            @Override
            public long getTimestamp(int col) {
                if (col == 4) {
                    return QueryActivityCursor.this.entry.getRegisteredAtNs();
                }
                if (col == 5) {
                    return QueryActivityCursor.this.entry.getChangedAtNs();
                }
                return Record.super.getTimestamp(col);
            }
        }
    }
}

