/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bind;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DoubleArrayParser;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlUtil;
import io.questdb.griffin.engine.functions.constants.ArrayConstant;
import io.questdb.std.Mutable;

public final class ArrayBindVariable
extends ArrayFunction
implements Mutable {
    private final DoubleArrayParser doubleArrayParser = new DoubleArrayParser();
    private ArrayView view;

    public void assignType(int type) throws SqlException {
        assert (ColumnType.isArray(type));
        if (this.view == null) {
            this.type = type;
            return;
        }
        int viewType = this.view.getType();
        if (ColumnType.isUnderdefined(viewType)) {
            this.type = type;
        }
        if (this.view.getType() != type) {
            throw SqlException.$(0, "type mismatch");
        }
    }

    @Override
    public void clear() {
        this.view = null;
        this.type = 0;
    }

    @Override
    public ArrayView getArray(Record rec) {
        if (this.view == null) {
            return ArrayConstant.NULL;
        }
        return this.view;
    }

    public void parseArray(CharSequence value) {
        this.view = SqlUtil.implicitCastStringAsDoubleArray(value, this.doubleArrayParser, this.type);
    }

    public void setView(ArrayView view) {
        if (view == null) {
            this.clear();
            return;
        }
        short elementType = ColumnType.decodeArrayElementType(view.getType());
        if (elementType != 6 && elementType != 10) {
            throw CairoException.nonCritical().put("unsupported array type, only DOUBLE is currently supported [type=").put(ColumnType.nameOf(elementType)).put(']');
        }
        if (ColumnType.isUnderdefined(this.type)) {
            this.type = view.getType();
        } else if (this.type != view.getType()) {
            throw CairoException.nonCritical().put("array type mismatch [expected=").put(ColumnType.nameOf(this.type)).put(", actual=").put(ColumnType.nameOf(view.getType())).put(']');
        }
        this.view = view;
    }
}

