/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.bool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class InSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "in(Kv)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = args.size();
        if (n == 1) {
            return BooleanConstant.FALSE;
        }
        CharSequenceHashSet set = new CharSequenceHashSet();
        ObjList<Function> deferredValues = null;
        IntList deferredValuePositions = null;
        block5: for (int i = 1; i < n; ++i) {
            Function func = args.getQuick(i);
            switch (ColumnType.tagOf(func.getType())) {
                case 0: 
                case 11: 
                case 26: {
                    if (func.isRuntimeConstant()) {
                        if (deferredValues == null) {
                            deferredValues = new ObjList<Function>();
                            deferredValuePositions = new IntList();
                        }
                        deferredValues.add(func);
                        deferredValuePositions.add(argPositions.getQuick(i));
                        continue block5;
                    }
                }
                case 12: 
                case 33: {
                    CharSequence value = func.getStrA(null);
                    if (value == null) {
                        set.add(null);
                        continue block5;
                    }
                    set.add(Chars.toString(value));
                    continue block5;
                }
                case 4: {
                    set.add(String.valueOf(func.getChar(null)));
                    continue block5;
                }
                default: {
                    throw SqlException.$(argPositions.getQuick(i), "STRING constant expected");
                }
            }
        }
        SymbolFunction var = (SymbolFunction)args.getQuick(0);
        if (var.isConstant() && deferredValues == null) {
            return BooleanConstant.of(set.contains(var.getSymbol(null)));
        }
        return new Func(var, set, deferredValues, deferredValuePositions);
    }

    private static class Func
    extends BooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final CharSequenceHashSet deferredSet;
        private final IntList deferredValuePositions;
        private final ObjList<Function> deferredValues;
        private final IntHashSet intSet = new IntHashSet();
        private final TestFunc intTest = this::testAsInt;
        private final CharSequenceHashSet set;
        private final TestFunc strTest = this::testAsString;
        private TestFunc testFunc;

        public Func(SymbolFunction arg, CharSequenceHashSet set, ObjList<Function> deferredValues, IntList deferredValuePositions) {
            this.arg = arg;
            this.set = set;
            this.deferredValues = deferredValues;
            this.deferredSet = deferredValues != null ? new CharSequenceHashSet() : null;
            this.deferredValuePositions = deferredValuePositions;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.testFunc.test(rec);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            int i;
            StaticSymbolTable symbolTable;
            this.arg.init(symbolTableSource, executionContext);
            if (this.deferredValues != null) {
                int n = this.deferredValues.size();
                block3: for (int i2 = 0; i2 < n; ++i2) {
                    this.deferredValues.getQuick(i2).init(symbolTableSource, executionContext);
                    Function func = this.deferredValues.getQuick(i2);
                    switch (ColumnType.tagOf(func.getType())) {
                        case 11: 
                        case 26: {
                            continue block3;
                        }
                        default: {
                            throw SqlException.inconvertibleTypes(this.deferredValuePositions.getQuick(i2), func.getType(), ColumnType.nameOf(func.getType()), 12, ColumnType.nameOf(12));
                        }
                    }
                }
            }
            if ((symbolTable = this.arg.getStaticSymbolTable()) != null) {
                this.intSet.clear();
                int n = this.set.size();
                for (i = 0; i < n; ++i) {
                    this.intSet.add(symbolTable.keyOf(this.set.get(i)));
                }
                if (this.deferredValues != null) {
                    n = this.deferredValues.size();
                    for (i = 0; i < n; ++i) {
                        Function func = this.deferredValues.getQuick(i);
                        this.intSet.add(symbolTable.keyOf(func.getStrA(null)));
                    }
                }
                this.testFunc = this.intTest;
            } else {
                if (this.deferredValues != null) {
                    this.deferredSet.clear();
                    int n = this.deferredValues.size();
                    for (i = 0; i < n; ++i) {
                        Function func = this.deferredValues.getQuick(i);
                        this.deferredSet.add(func.getStrA(null));
                    }
                }
                this.testFunc = this.strTest;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            boolean hasLiterals;
            sink.val(this.arg);
            boolean bl = hasLiterals = this.set != null && this.set.size() > 0;
            if (hasLiterals) {
                sink.val(" in ").val(this.set);
            }
            if (this.deferredValues != null && this.deferredValues.size() > 0) {
                if (hasLiterals) {
                    sink.val(" or ").val(this.arg);
                }
                sink.val(" in ").val(this.deferredValues);
            }
        }

        private boolean testAsInt(Record rec) {
            return this.intSet.contains(this.arg.getInt(rec));
        }

        private boolean testAsString(Record rec) {
            CharSequence symbol = this.arg.getSymbol(rec);
            if (this.set.contains(symbol)) {
                return true;
            }
            if (this.deferredSet != null) {
                return this.deferredSet.contains(symbol);
            }
            return false;
        }
    }

    @FunctionalInterface
    private static interface TestFunc {
        public boolean test(Record var1);
    }
}

