/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToTimestampFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class CastDoubleToTimestampFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Dn)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CastDoubleToTimestampFunction(args.getQuick(0));
    }

    public static class CastDoubleToTimestampFunction
    extends AbstractCastToTimestampFunction {
        public CastDoubleToTimestampFunction(Function arg) {
            super(arg);
        }

        @Override
        public long getTimestamp(Record rec) {
            double value = this.arg.getDouble(rec);
            return Numbers.isNull(value) || value > 9.223372036854776E18 || value < -9.223372036854776E18 ? Long.MIN_VALUE : (long)value;
        }
    }
}

