/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToGeoHashFunction;
import io.questdb.griffin.engine.functions.constants.Constants;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastStrToGeoHashFunctionFactory
implements FunctionFactory {
    public static Function newInstance(int argPosition, int geoType, Function value) throws SqlException {
        if (value.isConstant()) {
            int bits = ColumnType.getGeoHashBits(geoType);
            assert (bits > 0 && bits < 61);
            return Constants.getGeoHashConstantWithType(CastStrToGeoHashFunctionFactory.parseGeoHash(value.getStrA(null), argPosition, bits), geoType);
        }
        return new Func(geoType, value, argPosition);
    }

    public static long parseGeoHash(CharSequence value, int position, int typeBits) throws SqlException {
        if (value == null || value.length() == 0) {
            return -1L;
        }
        int actualBits = value.length() * 5;
        if (actualBits < typeBits) {
            throw SqlException.position(position).put("string is too short to cast to chosen GEOHASH precision [len=").put(value.length()).put(", precision=").put(typeBits).put(']');
        }
        int parseChars = (typeBits - 1) / 5 + 1;
        try {
            long lvalue = GeoHashes.fromString(value, 0, parseChars);
            return lvalue >>> parseChars * 5 - typeBits;
        }
        catch (NumericException e) {
            throw SqlException.position(position).put("invalid GEOHASH");
        }
    }

    @Override
    public String getSignature() {
        return "cast(Sg)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function value = args.getQuick(0);
        int argPosition = argPositions.getQuick(0);
        int geoType = args.getQuick(1).getType();
        return CastStrToGeoHashFunctionFactory.newInstance(argPosition, geoType, value);
    }

    public static class Func
    extends AbstractCastToGeoHashFunction {
        public Func(int geoType, Function arg, int position) {
            super(geoType, arg, position);
        }

        @Override
        protected long getGeoHashLong0(Record rec) {
            try {
                return CastStrToGeoHashFunctionFactory.parseGeoHash(this.arg.getStrA(rec), this.position, this.bitsPrecision);
            }
            catch (SqlException e) {
                return -1L;
            }
        }
    }
}

