/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToIPv4Function;
import io.questdb.griffin.engine.functions.constants.IPv4Constant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class CastStrToIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sx)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            CharSequence value = arg.getStrA(null);
            if (value == null || value.length() == 0) {
                return IPv4Constant.NULL;
            }
            try {
                int ip = Numbers.parseIPv4(value);
                return IPv4Constant.newInstance(ip);
            }
            catch (NumericException e) {
                throw SqlException.$(argPositions.getQuick(0), "invalid IPv4 constant");
            }
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractCastToIPv4Function {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getIPv4(Record rec) {
            return Numbers.parseIPv4Quiet(this.arg.getStrA(rec));
        }
    }
}

