/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Utf8SequenceIntHashMap;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class CastVarcharToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8k)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Utf8Sequence value = arg.getVarcharA(null);
            if (value == null) {
                return SymbolConstant.NULL;
            }
            StringSink utf16Sink = Misc.getThreadLocalSink();
            utf16Sink.put(value);
            return SymbolConstant.newInstance(utf16Sink);
        }
        return new Func(arg);
    }

    private static class Func
    extends SymbolFunction
    implements UnaryFunction {
        private final Function arg;
        private final Utf8SequenceIntHashMap lookupMap = new Utf8SequenceIntHashMap();
        private final ObjList<CharSequence> symbols = new ObjList();
        private int next = 1;

        public Func(Function arg) {
            this.arg = arg;
            this.symbols.add(null);
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            if (value == null) {
                return Integer.MIN_VALUE;
            }
            int keyIndex = this.lookupMap.keyIndex(value);
            if (keyIndex > -1) {
                String str = Utf8s.toString(value);
                this.lookupMap.putAt(keyIndex, value, this.next);
                this.symbols.add(str);
                return this.next++ - 1;
            }
            return this.lookupMap.valueAt(keyIndex) - 1;
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            if (value == null) {
                return null;
            }
            return this.getSymbol(value);
        }

        @Override
        public CharSequence getSymbolB(Record rec) {
            Utf8Sequence value = this.arg.getVarcharB(rec);
            if (value == null) {
                return null;
            }
            return this.getSymbol(value);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            this.lookupMap.clear();
            this.symbols.clear();
            this.symbols.add(null);
            this.next = 1;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public boolean isSymbolTableStatic() {
            return false;
        }

        @Override
        @Nullable
        public SymbolTable newSymbolTable() {
            Func copy = new Func(this.arg);
            copy.lookupMap.putAll(this.lookupMap);
            copy.symbols.clear();
            copy.symbols.addAll(this.symbols);
            copy.next = this.next;
            return copy;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::symbol");
        }

        @Override
        public CharSequence valueBOf(int key) {
            return this.valueOf(key);
        }

        @Override
        public CharSequence valueOf(int symbolKey) {
            return this.symbols.getQuick(TableUtils.toIndexKey(symbolKey));
        }

        private CharSequence getSymbol(Utf8Sequence value) {
            int keyIndex = this.lookupMap.keyIndex(value);
            if (keyIndex > -1) {
                String str = Utf8s.toString(value);
                this.lookupMap.putAt(keyIndex, value, this.next++);
                this.symbols.add(str);
                return str;
            }
            return this.symbols.getQuick(this.lookupMap.valueAt(keyIndex));
        }
    }
}

