/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.PGOids;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class PgAttributeFunctionFactory
implements FunctionFactory {
    public static final int N_ATTRELID_COL = 0;
    public static final int N_ATTNAME_COL = 1;
    private static final int N_ATTNUM_COL = 2;
    private static final int N_ATTTYPID_COL = 3;
    private static final int N_ATTNOTNULL_COL = 4;
    private static final int N_ATTTYPMOD_COL = 5;
    private static final int N_ATTLEN_COL = 6;
    private static final int N_ATTIDENTITY_COL = 7;
    private static final int N_ATTISDROPPED_COL = 8;
    private static final int N_ATTHASDEF_COL = 9;
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "pg_attribute()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new AttributeCatalogueCursorFactory()){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("attrelid", 5));
        metadata.add(new TableColumnMetadata("attname", 11));
        metadata.add(new TableColumnMetadata("attnum", 3));
        metadata.add(new TableColumnMetadata("atttypid", 5));
        metadata.add(new TableColumnMetadata("attnotnull", 1));
        metadata.add(new TableColumnMetadata("atttypmod", 5));
        metadata.add(new TableColumnMetadata("attlen", 3));
        metadata.add(new TableColumnMetadata("attidentity", 4));
        metadata.add(new TableColumnMetadata("attisdropped", 1));
        metadata.add(new TableColumnMetadata("atthasdef", 1));
        METADATA = metadata;
    }

    private static class AttributeCatalogueCursorFactory
    extends AbstractRecordCursorFactory {
        private final AttributeClassCatalogueCursor cursor;
        private final CharSequenceObjHashMap<CairoTable> tableCache = new CharSequenceObjHashMap();
        private long tableCacheVersion = -1L;

        public AttributeCatalogueCursorFactory() {
            super(METADATA);
            this.cursor = new AttributeClassCatalogueCursor(this.tableCache);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            CairoEngine engine = executionContext.getCairoEngine();
            try (MetadataCacheReader metadataRO = engine.getMetadataCache().readLock();){
                this.tableCacheVersion = metadataRO.snapshot(this.tableCache, this.tableCacheVersion);
            }
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(PgAttributeFunctionFactory.SIGNATURE);
        }
    }

    private static class AttributeClassCatalogueCursor
    implements NoRandomAccessRecordCursor {
        private final PgAttributeRecord record = new PgAttributeRecord();
        private final CharSequenceObjHashMap<CairoTable> tableCache;
        private int columnIdx = -1;
        private int iteratorIdx = -1;
        private CairoTable table;
        private int tableId;

        public AttributeClassCatalogueCursor(CharSequenceObjHashMap<CairoTable> tableCache) {
            this.tableCache = tableCache;
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            int type;
            if (this.table == null) {
                if (!this.nextTable()) {
                    return false;
                }
                this.tableId = this.table.getId();
            }
            assert (this.table != null);
            if (this.columnIdx < this.table.getColumnCount() - 1) {
                ++this.columnIdx;
            } else {
                this.columnIdx = -1;
                this.table = null;
                return this.hasNext();
            }
            CairoColumn column = this.table.getColumnQuiet(this.columnIdx);
            assert (column != null);
            this.record.intValues[3] = type = PGOids.getTypeOid(column.getType());
            this.record.name = column.getName();
            this.record.shortValues[2] = (short)(this.columnIdx + 1);
            this.record.shortValues[6] = PGOids.PG_TYPE_TO_SIZE_MAP.get(type);
            this.record.intValues[0] = this.tableId;
            this.record.intValues[5] = PGOids.getAttTypMod(type);
            return true;
        }

        public boolean nextTable() {
            assert (this.table == null);
            if (this.iteratorIdx >= this.tableCache.size() - 1) {
                return false;
            }
            this.table = this.tableCache.getAt(++this.iteratorIdx);
            return true;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.columnIdx = -1;
            this.table = null;
            this.iteratorIdx = -1;
        }

        static class PgAttributeRecord
        implements Record {
            public final int[] intValues = new int[9];
            public final short[] shortValues = new short[9];
            public CharSequence name = null;

            PgAttributeRecord() {
            }

            @Override
            public boolean getBool(int col) {
                return col == 9;
            }

            @Override
            public char getChar(int col) {
                return '\u0000';
            }

            @Override
            public int getInt(int col) {
                return this.intValues[col];
            }

            @Override
            public short getShort(int col) {
                return this.shortValues[col];
            }

            @Override
            public CharSequence getStrA(int col) {
                return this.name;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }
        }
    }
}

