/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DelegatingRecord;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;

public class PgClassFunctionFactory
implements FunctionFactory {
    private static final int INDEX_OID = 0;
    private static final int INDEX_RELNAME = 1;
    private static final RecordMetadata METADATA;
    private static final String[] relNames;
    private static final int fixedClassLen;
    private static final int[] staticOid;
    private static final int[] staticRelAllVisible;
    private static final int[] staticRelAm;
    private static final int[] staticRelFileNode;
    private static final int[] staticRelNamespace;
    private static final int[] staticRelOfType;
    private static final int[] staticRelOwner;
    private static final int[] staticRelRewrite;
    private static final int[] staticRelTablespace;
    private static final int[] staticRelToastRelId;
    private static final int[] staticRelType;
    private static final int[][] staticIntColumns;

    @Override
    public String getSignature() {
        return "pg_class()";
    }

    @Override
    public boolean isCursor() {
        return true;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new PgClassCursorFactory(METADATA)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        relNames = new String[]{"pg_class"};
        fixedClassLen = relNames.length;
        staticOid = new int[]{1259};
        staticRelAllVisible = new int[]{0};
        staticRelAm = new int[]{0};
        staticRelFileNode = new int[]{0};
        staticRelNamespace = new int[]{11};
        staticRelOfType = new int[]{0};
        staticRelOwner = new int[]{0};
        staticRelRewrite = new int[]{0};
        staticRelTablespace = new int[]{0};
        staticRelToastRelId = new int[]{0};
        staticRelType = new int[]{0};
        staticIntColumns = new int[][]{staticOid, null, staticRelNamespace, staticRelType, staticRelOfType, staticRelOwner, staticRelAm, staticRelFileNode, staticRelTablespace, null, null, staticRelAllVisible, staticRelToastRelId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, staticRelRewrite};
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 5));
        metadata.add(new TableColumnMetadata("relname", 11));
        metadata.add(new TableColumnMetadata("relnamespace", 5));
        metadata.add(new TableColumnMetadata("reltype", 5));
        metadata.add(new TableColumnMetadata("reloftype", 5));
        metadata.add(new TableColumnMetadata("relowner", 5));
        metadata.add(new TableColumnMetadata("relam", 5));
        metadata.add(new TableColumnMetadata("relfilenode", 5));
        metadata.add(new TableColumnMetadata("reltablespace", 5));
        metadata.add(new TableColumnMetadata("relpages", 1));
        metadata.add(new TableColumnMetadata("reltuples", 9));
        metadata.add(new TableColumnMetadata("relallvisible", 5));
        metadata.add(new TableColumnMetadata("reltoastrelid", 5));
        metadata.add(new TableColumnMetadata("relhasindex", 1));
        metadata.add(new TableColumnMetadata("relisshared", 1));
        metadata.add(new TableColumnMetadata("relpersistence", 4));
        metadata.add(new TableColumnMetadata("relkind", 4));
        metadata.add(new TableColumnMetadata("relnatts", 3));
        metadata.add(new TableColumnMetadata("relchecks", 3));
        metadata.add(new TableColumnMetadata("relhasrules", 1));
        metadata.add(new TableColumnMetadata("relhastriggers", 1));
        metadata.add(new TableColumnMetadata("relhassubclass", 1));
        metadata.add(new TableColumnMetadata("relrowsecurity", 1));
        metadata.add(new TableColumnMetadata("relforcerowsecurity", 1));
        metadata.add(new TableColumnMetadata("relispopulated", 1));
        metadata.add(new TableColumnMetadata("relreplident", 4));
        metadata.add(new TableColumnMetadata("relispartition", 1));
        metadata.add(new TableColumnMetadata("relrewrite", 5));
        metadata.add(new TableColumnMetadata("relfrozenxid", 6));
        metadata.add(new TableColumnMetadata("relminmxid", 6));
        metadata.add(new TableColumnMetadata("relacl", 11));
        metadata.add(new TableColumnMetadata("reloptions", 11));
        metadata.add(new TableColumnMetadata("relpartbound", 11));
        metadata.add(new TableColumnMetadata("relhasoids", 1));
        metadata.add(new TableColumnMetadata("xmin", 6));
        METADATA = metadata;
    }

    private static class PgClassCursorFactory
    extends AbstractRecordCursorFactory {
        private final PgClassRecordCursor cursor;
        private final Path path;
        private long tempMem;

        public PgClassCursorFactory(RecordMetadata metadata) {
            super(metadata);
            try {
                this.path = new Path();
                this.tempMem = Unsafe.malloc(4L, 31);
                this.cursor = new PgClassRecordCursor();
            }
            catch (Throwable th) {
                this.close();
                throw th;
            }
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.of(executionContext.getCairoEngine());
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("pg_class");
        }

        @Override
        protected void _close() {
            Misc.free(this.path);
            this.tempMem = Unsafe.free(this.tempMem, 4L, 31);
        }
    }

    private static class PgClassRecordCursor
    implements NoRandomAccessRecordCursor {
        private final DiskReadingRecord diskReadingRecord = new DiskReadingRecord();
        private final int[] intValues = new int[28];
        private final DelegatingRecord record = new DelegatingRecord();
        private final StaticReadingRecord staticReadingRecord = new StaticReadingRecord();
        private final ObjHashSet<TableToken> tableBucket = new ObjHashSet();
        private CairoEngine engine;
        private int fixedRelPos = -1;
        private int tableIndex = -1;
        private String tableName;

        public PgClassRecordCursor() {
            this.record.of(this.staticReadingRecord);
            this.intValues[0] = 0;
            this.intValues[2] = 2200;
            this.intValues[3] = 0;
            this.intValues[4] = 0;
            this.intValues[5] = 0;
            this.intValues[6] = 0;
            this.intValues[7] = 0;
            this.intValues[8] = 0;
            this.intValues[11] = 0;
            this.intValues[12] = 0;
            this.intValues[27] = 0;
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (++this.fixedRelPos < fixedClassLen) {
                return true;
            }
            this.record.of(this.diskReadingRecord);
            if (this.tableIndex < 0) {
                this.engine.getTableTokens(this.tableBucket, false);
                this.tableIndex = 0;
            }
            if (this.tableIndex == this.tableBucket.size()) {
                return false;
            }
            TableToken token = this.tableBucket.get(this.tableIndex++);
            this.tableName = token.getTableName();
            this.intValues[0] = token.getTableId();
            return true;
        }

        public void of(CairoEngine engine) {
            this.engine = engine;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.fixedRelPos = -1;
            this.record.of(this.staticReadingRecord);
            this.tableIndex = -1;
        }

        private class DiskReadingRecord
        implements Record {
            private DiskReadingRecord() {
            }

            @Override
            public boolean getBool(int col) {
                return col == 24;
            }

            @Override
            public char getChar(int col) {
                switch (col) {
                    case 15: {
                        return 'p';
                    }
                    case 16: {
                        return 'r';
                    }
                }
                return 'd';
            }

            @Override
            public float getFloat(int col) {
                return -1.0f;
            }

            @Override
            public int getInt(int col) {
                return PgClassRecordCursor.this.intValues[col];
            }

            @Override
            public long getLong(int col) {
                return 0L;
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public CharSequence getStrA(int col) {
                if (col == 1) {
                    return PgClassRecordCursor.this.tableName;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }
        }

        private class StaticReadingRecord
        implements Record {
            private StaticReadingRecord() {
            }

            @Override
            public boolean getBool(int col) {
                return false;
            }

            @Override
            public char getChar(int col) {
                switch (col) {
                    case 15: {
                        return 'u';
                    }
                    case 16: {
                        return 'r';
                    }
                }
                return 'd';
            }

            @Override
            public float getFloat(int col) {
                return -1.0f;
            }

            @Override
            public int getInt(int col) {
                return staticIntColumns[col][PgClassRecordCursor.this.fixedRelPos];
            }

            @Override
            public long getLong(int col) {
                return 0L;
            }

            @Override
            public short getShort(int col) {
                return 0;
            }

            @Override
            public CharSequence getStrA(int col) {
                if (col == 1) {
                    return relNames[PgClassRecordCursor.this.fixedRelPos];
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }
        }
    }
}

