/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.ConfigPropertyKey;
import io.questdb.ConfigPropertyValue;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.ObjObjHashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ShowParametersCursorFactory
extends AbstractRecordCursorFactory {
    private static final GenericRecordMetadata METADATA = new GenericRecordMetadata();
    private final ShowParametersRecordCursor cursor = new ShowParametersRecordCursor();

    public ShowParametersCursorFactory() {
        super(METADATA);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of(executionContext.getCairoEngine().getConfiguration().getAllPairs());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show parameters");
    }

    static {
        METADATA.add(new TableColumnMetadata("property_path", 11));
        METADATA.add(new TableColumnMetadata("env_var_name", 11));
        METADATA.add(new TableColumnMetadata("value", 11));
        METADATA.add(new TableColumnMetadata("value_source", 11));
        METADATA.add(new TableColumnMetadata("sensitive", 1));
        METADATA.add(new TableColumnMetadata("reloadable", 1));
    }

    private static class ShowParametersRecordCursor
    implements NoRandomAccessRecordCursor {
        private ObjObjHashMap<ConfigPropertyKey, ConfigPropertyValue> allPairs;
        private ObjObjHashMap.Entry<ConfigPropertyKey, ConfigPropertyValue> entry;
        private final Record record = new Record(){

            @Override
            public boolean getBool(int col) {
                switch (col) {
                    case 4: {
                        return ((ConfigPropertyKey)entry.key).isSensitive();
                    }
                    case 5: {
                        return ((ConfigPropertyValue)entry.value).isDynamic();
                    }
                }
                return false;
            }

            @Override
            public CharSequence getStrA(int col) {
                switch (col) {
                    case 0: {
                        return ((ConfigPropertyKey)entry.key).getPropertyPath();
                    }
                    case 1: {
                        return ((ConfigPropertyKey)entry.key).getEnvVarName();
                    }
                    case 2: {
                        if (((ConfigPropertyKey)entry.key).isSensitive()) {
                            return "****";
                        }
                        return ((ConfigPropertyValue)entry.value).getValue();
                    }
                    case 3: {
                        switch (((ConfigPropertyValue)entry.value).getValueSource()) {
                            case 0: {
                                return "default";
                            }
                            case 1: {
                                return "conf";
                            }
                        }
                        return "env";
                    }
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }
        };
        @NotNull
        private Iterator<ObjObjHashMap.Entry<ConfigPropertyKey, ConfigPropertyValue>> iterator = EmptyIterator.INSTANCE;

        private ShowParametersRecordCursor() {
        }

        @Override
        public void close() {
            this.iterator = EmptyIterator.INSTANCE;
            this.allPairs = null;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                this.entry = this.iterator.next();
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.iterator = this.allPairs != null ? this.allPairs.iterator() : EmptyIterator.INSTANCE;
            this.entry = null;
        }

        private ShowParametersRecordCursor of(ObjObjHashMap<ConfigPropertyKey, ConfigPropertyValue> allPairs) {
            this.allPairs = allPairs;
            this.toTop();
            return this;
        }
    }

    private static final class EmptyIterator
    implements Iterator<ObjObjHashMap.Entry<ConfigPropertyKey, ConfigPropertyValue>> {
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ObjObjHashMap.Entry<ConfigPropertyKey, ConfigPropertyValue> next() {
            return null;
        }
    }
}

