/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.TimestampFloorFunctions;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DateTruncFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "date_trunc(sN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function kindFunction = args.getQuick(0);
        CharSequence kind = kindFunction.getStrA(null);
        Function innerFunction = args.getQuick(1);
        if (kind == null) {
            throw SqlException.position(argPositions.getQuick(0)).put("invalid unit 'null'");
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "microsecond")) {
            return innerFunction;
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "millisecond")) {
            return new TimestampFloorFunctions.TimestampFloorMSFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "second")) {
            return new TimestampFloorFunctions.TimestampFloorSSFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "minute")) {
            return new TimestampFloorFunctions.TimestampFloorMIFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "hour")) {
            return new TimestampFloorFunctions.TimestampFloorHHFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "day")) {
            return new TimestampFloorFunctions.TimestampFloorDDFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "week")) {
            return new TimestampFloorFunctions.TimestampFloorDayOfWeekFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "month")) {
            return new TimestampFloorFunctions.TimestampFloorMMFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "quarter")) {
            return new TimestampFloorFunctions.TimestampFloorQuarterFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "year")) {
            return new TimestampFloorFunctions.TimestampFloorYYYYFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "decade")) {
            return new TimestampFloorFunctions.TimestampFloorDecadeFunction(innerFunction);
        }
        if (Chars.equals(kind, (CharSequence)"century") || Chars.equals(kind, (CharSequence)"centuries")) {
            return new TimestampFloorFunctions.TimestampFloorCenturyFunction(innerFunction);
        }
        if (DateTruncFunctionFactory.isTimeUnit(kind, "millennium")) {
            return new TimestampFloorFunctions.TimestampFloorMillenniumFunction(innerFunction);
        }
        throw SqlException.$(argPositions.getQuick(0), "invalid unit '").put(kind).put('\'');
    }

    private static boolean isTimeUnit(CharSequence arg, String constant) {
        if (Chars.startsWith(arg, constant)) {
            int constLen;
            int argLen = arg.length();
            if (argLen == (constLen = constant.length())) {
                return true;
            }
            if (argLen == constLen + 1) {
                return arg.charAt(argLen - 1) == 's';
            }
        }
        return false;
    }
}

