/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.date.AbstractGenerateSeriesRecordCursorFactory;
import io.questdb.griffin.engine.functions.date.TimestampAddFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.Timestamps;
import org.jetbrains.annotations.Nullable;

public class GenerateSeriesTimestampStringRecordCursorFactory
extends AbstractGenerateSeriesRecordCursorFactory {
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_DAYS_FUNCTION = Timestamps::addDays;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_HOURS_FUNCTION = Timestamps::addHours;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_MICROS_FUNCTION = Timestamps::addMicros;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_MILLIS_FUNCTION = Timestamps::addMillis;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_MINUTES_FUNCTION = Timestamps::addMinutes;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_MONTHS_FUNCTION = Timestamps::addMonths;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_SECONDS_FUNCTION = Timestamps::addSeconds;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_WEEKS_FUNCTION = Timestamps::addWeeks;
    public static final TimestampAddFunctionFactory.LongAddIntFunction ADD_YEARS_FUNCTION = Timestamps::addYears;
    private static final RecordMetadata METADATA;
    private static final ThreadLocal<GenerateSeriesTimestampStringRecordCursor.GenerateSeriesPeriod> tlSampleByUnit;
    private GenerateSeriesTimestampStringRecordCursor cursor;

    public GenerateSeriesTimestampStringRecordCursorFactory(Function startFunc, Function endFunc, Function stepFunc, IntList argPositions) throws SqlException {
        super(METADATA, startFunc, endFunc, stepFunc, argPositions);
    }

    @Nullable
    public static TimestampAddFunctionFactory.LongAddIntFunction lookupAddFunction(char period) {
        switch (period) {
            case 'U': 
            case 'u': {
                return ADD_MICROS_FUNCTION;
            }
            case 'T': {
                return ADD_MILLIS_FUNCTION;
            }
            case 's': {
                return ADD_SECONDS_FUNCTION;
            }
            case 'm': {
                return ADD_MINUTES_FUNCTION;
            }
            case 'H': 
            case 'h': {
                return ADD_HOURS_FUNCTION;
            }
            case 'd': {
                return ADD_DAYS_FUNCTION;
            }
            case 'w': {
                return ADD_WEEKS_FUNCTION;
            }
            case 'M': {
                return ADD_MONTHS_FUNCTION;
            }
            case 'y': {
                return ADD_YEARS_FUNCTION;
            }
        }
        return null;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        if (this.cursor == null) {
            this.cursor = new GenerateSeriesTimestampStringRecordCursor(this.startFunc, this.endFunc, this.stepFunc);
        }
        this.cursor.of(executionContext, this.stepPosition);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        if (this.cursor != null && this.cursor.stride != 0) {
            return this.cursor.stride > 0 ? 1 : 2;
        }
        return 1;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        if (this.cursor == null) {
            return false;
        }
        return this.cursor.supportsRandomAccess();
    }

    static {
        tlSampleByUnit = new ThreadLocal<GenerateSeriesTimestampStringRecordCursor.GenerateSeriesPeriod>(GenerateSeriesTimestampStringRecordCursor.GenerateSeriesPeriod::new);
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("generate_series", 8));
        metadata.setTimestampIndex(0);
        METADATA = metadata;
    }

    private static class GenerateSeriesTimestampStringRecordCursor
    extends AbstractGenerateSeriesRecordCursorFactory.AbstractGenerateSeriesRecordCursor {
        private final GenerateSeriesTimestampStringRecord recordA = new GenerateSeriesTimestampStringRecord();
        private final GenerateSeriesTimestampStringRecord recordB = new GenerateSeriesTimestampStringRecord();
        public int stride;
        private TimestampAddFunctionFactory.LongAddIntFunction adder;
        private long end;
        private long start;
        private char unit;

        public GenerateSeriesTimestampStringRecordCursor(Function startFunc, Function endFunc, Function stepFunc) {
            super(startFunc, endFunc, stepFunc);
        }

        public static void throwInvalidPeriod(CharSequence stepStr, int stepPosition) throws SqlException {
            throw SqlException.$(stepPosition, "invalid period [period=").put(stepStr).put(']');
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            while (this.hasNext()) {
                counter.inc();
            }
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public Record getRecordB() {
            if (this.supportsRandomAccess()) {
                return this.recordB;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            this.recordA.of(this.adder.add(this.recordA.curr, this.stride));
            if (this.stride >= 0) {
                return this.recordA.curr <= this.end;
            }
            return this.recordA.curr >= this.end;
        }

        public void of(SqlExecutionContext executionContext, int stepPosition) throws SqlException {
            super.of(executionContext);
            this.start = this.startFunc.getTimestamp(null);
            this.end = this.endFunc.getTimestamp(null);
            CharSequence stepStr = this.stepFunc.getStrA(null);
            GenerateSeriesPeriod sbu = tlSampleByUnit.get();
            sbu.parse(stepStr, stepPosition);
            this.adder = GenerateSeriesTimestampStringRecordCursorFactory.lookupAddFunction(sbu.unit);
            if (this.adder == null) {
                GenerateSeriesTimestampStringRecordCursor.throwInvalidPeriod(stepStr, stepPosition);
            }
            this.unit = sbu.unit;
            if (sbu.stride == 0) {
                throw SqlException.$(stepPosition, "stride cannot be zero");
            }
            this.stride = sbu.stride;
            if (this.start <= this.end && this.stride < 0 || this.start >= this.end && this.stride > 0) {
                long temp = this.start;
                this.start = this.end;
                this.end = temp;
            }
            this.toTop();
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            if (this.supportsRandomAccess()) {
                long micros = this.adjustStride();
                ((GenerateSeriesTimestampStringRecord)record).of(this.start + micros * (atRowId - 1L));
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() {
            long micros = this.stride;
            switch (this.unit) {
                case 'w': {
                    micros *= 604800000000L;
                    break;
                }
                case 'd': {
                    micros *= 86400000000L;
                    break;
                }
                case 'h': {
                    micros *= 3600000000L;
                    break;
                }
                case 'm': {
                    micros *= 60000000L;
                    break;
                }
                case 's': {
                    micros *= 1000000L;
                    break;
                }
                case 'T': {
                    micros *= 1000L;
                    break;
                }
                case 'U': 
                case 'u': {
                    break;
                }
                default: {
                    return -1L;
                }
            }
            return Math.abs(this.end - this.start) / Math.abs(micros) + 1L;
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) {
            if (this.supportsRandomAccess()) {
                long newRowId = this.recordA.getRowId() + rowCount.get() - 1L - 1L;
                this.recordAt(this.recordA, newRowId);
            } else {
                super.skipRows(rowCount);
            }
        }

        public boolean supportsRandomAccess() {
            switch (this.unit) {
                case 'M': 
                case 'y': {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void toTop() {
            this.recordA.of(this.adder.add(this.start, -this.stride));
        }

        private long adjustStride() {
            switch (this.unit) {
                case 'w': {
                    return (long)this.stride * 604800000000L;
                }
                case 'd': {
                    return (long)this.stride * 86400000000L;
                }
                case 'h': {
                    return (long)this.stride * 3600000000L;
                }
                case 'm': {
                    return (long)this.stride * 60000000L;
                }
                case 's': {
                    return (long)this.stride * 1000000L;
                }
                case 'T': {
                    return (long)this.stride * 1000L;
                }
                case 'U': 
                case 'u': {
                    return this.stride;
                }
            }
            throw new UnsupportedOperationException();
        }

        private class GenerateSeriesTimestampStringRecord
        implements Record {
            private long curr;

            private GenerateSeriesTimestampStringRecord() {
            }

            @Override
            public long getLong(int col) {
                return this.curr;
            }

            @Override
            public long getRowId() {
                if (GenerateSeriesTimestampStringRecordCursor.this.supportsRandomAccess()) {
                    return Math.abs(GenerateSeriesTimestampStringRecordCursor.this.start - this.curr) / Math.abs(GenerateSeriesTimestampStringRecordCursor.this.adjustStride()) + 1L;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public long getTimestamp(int col) {
                return this.curr;
            }

            public void of(long value) {
                this.curr = value;
            }
        }

        public static class GenerateSeriesPeriod {
            public int stride = 0;
            public char unit = '\u0000';

            public static boolean isPotentiallyValidUnit(char c) {
                switch (c) {
                    case 'H': 
                    case 'M': 
                    case 'T': 
                    case 'U': 
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 's': 
                    case 'u': 
                    case 'w': 
                    case 'y': {
                        return true;
                    }
                }
                return false;
            }

            public void clear() {
                this.of(0, '\u0000');
            }

            public void of(int stride, char unit) {
                this.stride = stride;
                this.unit = unit;
            }

            public boolean parse(CharSequence str, int position) throws SqlException {
                if (str == null) {
                    throw SqlException.$(position, "null step");
                }
                int len = str.length();
                switch (len) {
                    case 0: {
                        throw SqlException.$(position, "empty step");
                    }
                    case 1: {
                        this.unit = str.charAt(0);
                        this.stride = 1;
                        break;
                    }
                    case 2: {
                        if (str.charAt(0) == '-') {
                            this.unit = str.charAt(1);
                            this.stride = -1;
                            break;
                        }
                    }
                    default: {
                        this.unit = str.charAt(str.length() - 1);
                        try {
                            this.stride = Numbers.parseInt(str, 0, str.length() - 1);
                            break;
                        }
                        catch (NumericException ignored) {
                            GenerateSeriesTimestampStringRecordCursor.throwInvalidPeriod(str, position);
                        }
                    }
                }
                if (!GenerateSeriesPeriod.isPotentiallyValidUnit(this.unit)) {
                    GenerateSeriesTimestampStringRecordCursor.throwInvalidPeriod(str, position);
                }
                return true;
            }
        }
    }
}

