/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.datetime.microtime.Timestamps;

final class TimestampFloorFunctions {
    private TimestampFloorFunctions() {
    }

    static class TimestampFloorYYYYFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorYYYYFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorYYYYFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return this.stride > 1 ? Timestamps.floorYYYY(timestamp, this.stride) : Timestamps.floorYYYY(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "year";
        }
    }

    static class TimestampFloorWWFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorWWFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorWW(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "week";
        }
    }

    static class TimestampFloorSSFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorSSFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorSSFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorSS(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "second";
        }
    }

    static class TimestampFloorQuarterFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorQuarterFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorQuarter(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "quarter";
        }
    }

    static class TimestampFloorMillenniumFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorMillenniumFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMillennium(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "millennium";
        }
    }

    static class TimestampFloorMSFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorMSFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorMSFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMS(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "millisecond";
        }
    }

    static class TimestampFloorMMFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorMMFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorMMFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return this.stride > 1 ? Timestamps.floorMM(timestamp, this.stride) : Timestamps.floorMM(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "month";
        }
    }

    static class TimestampFloorMIFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorMIFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorMIFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMI(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "minute";
        }
    }

    static class TimestampFloorMCFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorMCFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMC(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "microsecond";
        }
    }

    static class TimestampFloorHHFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorHHFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorHHFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorHH(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "hour";
        }
    }

    static class TimestampFloorDecadeFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDecadeFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDecade(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "decade";
        }
    }

    static class TimestampFloorDayOfWeekFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorDayOfWeekFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDOW(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "week";
        }
    }

    static class TimestampFloorDDFunction
    extends AbstractTimestampFloorFunction {
        private final int stride;

        public TimestampFloorDDFunction(Function arg) {
            this(arg, 1);
        }

        public TimestampFloorDDFunction(Function arg, int stride) {
            super(arg);
            this.stride = stride;
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDD(timestamp, this.stride);
        }

        @Override
        CharSequence getUnit() {
            return "day";
        }
    }

    static class TimestampFloorCenturyFunction
    extends AbstractTimestampFloorFunction {
        public TimestampFloorCenturyFunction(Function arg) {
            super(arg);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorCentury(timestamp);
        }

        @Override
        CharSequence getUnit() {
            return "century";
        }
    }

    static abstract class AbstractTimestampFloorFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;

        public AbstractTimestampFloorFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long micros = this.arg.getTimestamp(rec);
            return micros == Long.MIN_VALUE ? Long.MIN_VALUE : this.floor(micros);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('").val(this.getUnit()).val("',").val(this.getArg()).val(')');
        }

        protected abstract long floor(long var1);

        abstract CharSequence getUnit();
    }
}

