/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.datetime.microtime.Timestamps;

final class TimestampFloorOffsetFunctions {
    private TimestampFloorOffsetFunctions() {
    }

    static class TimestampFloorOffsetYYYYFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetYYYYFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorYYYY(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'y';
        }
    }

    static class TimestampFloorOffsetWWFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetWWFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorWW(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'w';
        }
    }

    static class TimestampFloorOffsetSSFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetSSFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorSS(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 's';
        }
    }

    static class TimestampFloorOffsetMSFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetMSFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMS(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'T';
        }
    }

    static class TimestampFloorOffsetMMFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetMMFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMM(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'M';
        }
    }

    static class TimestampFloorOffsetMIFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetMIFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMI(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'm';
        }
    }

    static class TimestampFloorOffsetMCFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetMCFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorMC(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'U';
        }
    }

    static class TimestampFloorOffsetHHFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetHHFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorHH(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'h';
        }
    }

    static class TimestampFloorOffsetDDFunction
    extends AbstractTimestampFloorOffsetFunction {
        public TimestampFloorOffsetDDFunction(Function arg, int stride, long offset) {
            super(arg, stride, offset);
        }

        @Override
        public long floor(long timestamp) {
            return Timestamps.floorDD(timestamp, this.stride, this.offset);
        }

        @Override
        char getUnit() {
            return 'd';
        }
    }

    static abstract class AbstractTimestampFloorOffsetFunction
    extends TimestampFunction
    implements UnaryFunction {
        protected final long offset;
        protected final int stride;
        private final Function arg;

        public AbstractTimestampFloorOffsetFunction(Function arg, int stride, long offset) {
            this.arg = arg;
            this.stride = stride;
            this.offset = offset;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public final long getTimestamp(Record rec) {
            long micros = this.arg.getTimestamp(rec);
            return micros == Long.MIN_VALUE ? Long.MIN_VALUE : this.floor(micros);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("timestamp_floor").val("('");
            sink.val(this.stride);
            sink.val(this.getUnit()).val("',");
            sink.val(this.getArg());
            if (this.offset != 0L) {
                sink.val(",'").val(Timestamps.toString(this.offset)).val('\'');
            }
            sink.val(')');
        }

        protected abstract long floor(long var1);

        abstract char getUnit();
    }
}

