/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Acceptor;
import io.questdb.std.Long256FromCharSequenceDecoder;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class EqLong256StrFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<Long256ConstDecoder> DECODER = ThreadLocal.withInitial(() -> new Long256ConstDecoder());

    @Override
    public String getSignature() {
        return "=(HS)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function long256Func = args.getQuick(0);
        int strFuncPosition = argPositions.getQuick(1);
        Function strFunc = args.getQuick(1);
        if (strFunc.isConstant()) {
            CharSequence value = strFunc.getStrA(null);
            if (value == null) {
                return new ConstStrFunc(long256Func);
            }
            Long256ConstDecoder decoder = DECODER.get();
            decoder.decode(value);
            return new ConstStrFunc(long256Func, decoder.long0, decoder.long1, decoder.long2, decoder.long3);
        }
        if (strFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(long256Func, strFunc);
        }
        throw SqlException.$(strFuncPosition, "STRING constant expected");
    }

    private static class ConstStrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final long constLong0;
        private final long constLong1;
        private final long constLong2;
        private final long constLong3;
        private final Function strFunc;

        public ConstStrFunc(Function strFunc) {
            this(strFunc, Long256Impl.NULL_LONG256.getLong0(), Long256Impl.NULL_LONG256.getLong1(), Long256Impl.NULL_LONG256.getLong2(), Long256Impl.NULL_LONG256.getLong3());
        }

        public ConstStrFunc(Function strFunc, long constLong0, long constLong1, long constLong2, long constLong3) {
            this.constLong0 = constLong0;
            this.constLong1 = constLong1;
            this.constLong2 = constLong2;
            this.constLong3 = constLong3;
            this.strFunc = strFunc;
        }

        @Override
        public Function getArg() {
            return this.strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            Long256 value = this.strFunc.getLong256A(rec);
            return this.negated != (value.getLong0() == this.constLong0 && value.getLong1() == this.constLong1 && value.getLong2() == this.constLong2 && value.getLong3() == this.constLong3);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.strFunc);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=');
            sink.valLong256(this.constLong0, this.constLong1, this.constLong2, this.constLong3);
        }
    }

    private static class Long256ConstDecoder {
        long long0;
        long long1;
        long long2;
        long long3;
        final Long256Acceptor decoder = this::setAll;

        private Long256ConstDecoder() {
        }

        public void setAll(long l0, long l1, long l2, long l3) {
            this.long0 = l0;
            this.long1 = l1;
            this.long2 = l2;
            this.long3 = l3;
        }

        private void decode(CharSequence hexLong256) {
            Long256FromCharSequenceDecoder.decode(hexLong256, 2, hexLong256.length(), this.decoder);
        }
    }

    private static class RuntimeConstStrFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function long256Func;
        private final Function strFunc;
        private long constLong0;
        private long constLong1;
        private long constLong2;
        private long constLong3;
        final Long256Acceptor decoder = this::setAll;

        public RuntimeConstStrFunc(Function long256Func, Function strFunc) {
            this.long256Func = long256Func;
            this.strFunc = strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            Long256 value = this.long256Func.getLong256A(rec);
            return this.negated != (value.getLong0() == this.constLong0 && value.getLong1() == this.constLong1 && value.getLong2() == this.constLong2 && value.getLong3() == this.constLong3);
        }

        @Override
        public Function getLeft() {
            return this.long256Func;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            CharSequence value = this.strFunc.getStrA(null);
            if (value == null) {
                this.constLong0 = Long256Impl.NULL_LONG256.getLong0();
                this.constLong1 = Long256Impl.NULL_LONG256.getLong1();
                this.constLong2 = Long256Impl.NULL_LONG256.getLong2();
                this.constLong3 = Long256Impl.NULL_LONG256.getLong3();
            } else {
                Long256FromCharSequenceDecoder.decode(value, 2, value.length(), this.decoder);
            }
        }

        public void setAll(long l0, long l1, long l2, long l3) {
            this.constLong0 = l0;
            this.constLong1 = l1;
            this.constLong2 = l2;
            this.constLong3 = l3;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.long256Func);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=');
            sink.val(this.strFunc);
        }
    }
}

