/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class CorrGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "corr(DD)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CorrGroupByFunction(args.getQuick(0), args.getQuick(1));
    }

    private static class CorrGroupByFunction
    extends DoubleFunction
    implements GroupByFunction,
    BinaryFunction {
        protected final Function xFunc;
        protected final Function yFunc;
        protected int valueIndex;

        protected CorrGroupByFunction(@NotNull Function arg0, @NotNull Function arg1) {
            this.yFunc = arg0;
            this.xFunc = arg1;
        }

        @Override
        public void computeFirst(MapValue mapValue, Record record, long rowId) {
            double y = this.yFunc.getDouble(record);
            double x = this.xFunc.getDouble(record);
            mapValue.putDouble(this.valueIndex, 0.0);
            mapValue.putDouble(this.valueIndex + 1, 0.0);
            mapValue.putDouble(this.valueIndex + 2, 0.0);
            mapValue.putDouble(this.valueIndex + 3, 0.0);
            mapValue.putDouble(this.valueIndex + 4, 0.0);
            mapValue.putLong(this.valueIndex + 5, 0L);
            if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
                this.aggregate(mapValue, y, x);
            }
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            double y = this.yFunc.getDouble(record);
            double x = this.xFunc.getDouble(record);
            if (Numbers.isFinite(y) && Numbers.isFinite(x)) {
                this.aggregate(mapValue, y, x);
            }
        }

        @Override
        public double getDouble(Record rec) {
            double sumY = rec.getDouble(this.valueIndex + 1);
            double sumX = rec.getDouble(this.valueIndex + 3);
            double sumXY = rec.getDouble(this.valueIndex + 4);
            double count = rec.getLong(this.valueIndex + 5);
            if (count <= 0.0) {
                return Double.NaN;
            }
            if (sumY == 0.0 || sumX == 0.0) {
                return Double.NaN;
            }
            return sumXY / Math.sqrt(sumY * sumX);
        }

        @Override
        public Function getLeft() {
            return this.yFunc;
        }

        @Override
        public String getName() {
            return "corr";
        }

        @Override
        public Function getRight() {
            return this.xFunc;
        }

        @Override
        public int getValueIndex() {
            return this.valueIndex;
        }

        @Override
        public void initValueIndex(int valueIndex) {
            this.valueIndex = valueIndex;
        }

        @Override
        public void initValueTypes(ArrayColumnTypes columnTypes) {
            this.valueIndex = columnTypes.getColumnCount();
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(10);
            columnTypes.add(6);
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            double srcMeanY = srcValue.getDouble(this.valueIndex);
            double srcSumY = srcValue.getDouble(this.valueIndex + 1);
            double srcMeanX = srcValue.getDouble(this.valueIndex + 2);
            double srcSumX = srcValue.getDouble(this.valueIndex + 3);
            double srcSumXY = srcValue.getDouble(this.valueIndex + 4);
            long srcCount = srcValue.getLong(this.valueIndex + 5);
            double destMeanY = destValue.getDouble(this.valueIndex);
            double destSumY = destValue.getDouble(this.valueIndex + 1);
            double destMeanX = destValue.getDouble(this.valueIndex + 2);
            double destSumX = destValue.getDouble(this.valueIndex + 3);
            double destSumXY = destValue.getDouble(this.valueIndex + 4);
            long destCount = destValue.getLong(this.valueIndex + 5);
            long mergedCount = srcCount + destCount;
            double deltaY = destMeanY - srcMeanY;
            double deltaX = destMeanX - srcMeanX;
            double mergedMeanY = ((double)srcCount * srcMeanY + (double)destCount * destMeanY) / (double)mergedCount;
            double mergedSumY = srcSumY + destSumY + deltaY * deltaY * ((double)(srcCount * destCount) / (double)mergedCount);
            double mergedMeanX = ((double)srcCount * srcMeanX + (double)destCount * destMeanX) / (double)mergedCount;
            double mergedSumX = srcSumX + destSumX + deltaX * deltaX * ((double)(srcCount * destCount) / (double)mergedCount);
            double mergedSumXY = srcSumXY + destSumXY + deltaX * deltaY * ((double)(srcCount * destCount) / (double)mergedCount);
            destValue.putDouble(this.valueIndex, mergedMeanY);
            destValue.putDouble(this.valueIndex + 1, mergedSumY);
            destValue.putDouble(this.valueIndex + 2, mergedMeanX);
            destValue.putDouble(this.valueIndex + 3, mergedSumX);
            destValue.putDouble(this.valueIndex + 4, mergedSumXY);
            destValue.putLong(this.valueIndex + 5, mergedCount);
        }

        @Override
        public void setDouble(MapValue mapValue, double value) {
            mapValue.putDouble(this.valueIndex + 4, value);
            mapValue.putLong(this.valueIndex + 5, 1L);
        }

        @Override
        public void setNull(MapValue mapValue) {
            mapValue.putDouble(this.valueIndex, Double.NaN);
            mapValue.putDouble(this.valueIndex + 1, Double.NaN);
            mapValue.putDouble(this.valueIndex + 2, Double.NaN);
            mapValue.putDouble(this.valueIndex + 3, Double.NaN);
            mapValue.putDouble(this.valueIndex + 4, Double.NaN);
            mapValue.putLong(this.valueIndex + 5, 0L);
        }

        @Override
        public boolean supportsParallelism() {
            return true;
        }

        protected void aggregate(MapValue mapValue, double y, double x) {
            double meanY = mapValue.getDouble(this.valueIndex);
            double sumY = mapValue.getDouble(this.valueIndex + 1);
            double meanX = mapValue.getDouble(this.valueIndex + 2);
            double sumX = mapValue.getDouble(this.valueIndex + 3);
            double sumXY = mapValue.getDouble(this.valueIndex + 4);
            long count = mapValue.getLong(this.valueIndex + 5) + 1L;
            double oldMeanY = meanY;
            meanY += (y - meanY) / (double)count;
            double oldMeanX = meanX;
            meanX += (x - meanX) / (double)count;
            mapValue.putDouble(this.valueIndex, meanY);
            mapValue.putDouble(this.valueIndex + 1, sumY += (y - meanY) * (y - oldMeanY));
            mapValue.putDouble(this.valueIndex + 2, meanX);
            mapValue.putDouble(this.valueIndex + 3, sumX += (x - meanX) * (x - oldMeanX));
            mapValue.putDouble(this.valueIndex + 4, sumXY += (y - oldMeanY) * (x - meanX));
            mapValue.addLong(this.valueIndex + 5, 1L);
        }
    }
}

