/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByLong256HashSet;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;

public class CountDistinctLong256GroupByFunction
extends LongFunction
implements UnaryFunction,
GroupByFunction {
    private final Function arg;
    private final GroupByLong256HashSet setA;
    private final GroupByLong256HashSet setB;
    private int valueIndex;

    public CountDistinctLong256GroupByFunction(Function arg, int setInitialCapacity, double setLoadFactor) {
        this.arg = arg;
        this.setA = new GroupByLong256HashSet(setInitialCapacity, setLoadFactor, Long.MIN_VALUE);
        this.setB = new GroupByLong256HashSet(setInitialCapacity, setLoadFactor, Long.MIN_VALUE);
    }

    @Override
    public void clear() {
        this.setA.resetPtr();
        this.setB.resetPtr();
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        Long256 l256 = this.arg.getLong256A(record);
        if (CountDistinctLong256GroupByFunction.isNotNull(l256)) {
            mapValue.putLong(this.valueIndex, 1L);
            long l0 = l256.getLong0();
            long l1 = l256.getLong1();
            long l2 = l256.getLong2();
            long l3 = l256.getLong3();
            this.setA.of(0L).add(l0, l1, l2, l3);
            mapValue.putLong(this.valueIndex + 1, this.setA.ptr());
        } else {
            mapValue.putLong(this.valueIndex, 0L);
            mapValue.putLong(this.valueIndex + 1, 0L);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        Long256 l256 = this.arg.getLong256A(record);
        if (CountDistinctLong256GroupByFunction.isNotNull(l256)) {
            long l0 = l256.getLong0();
            long l1 = l256.getLong1();
            long l2 = l256.getLong2();
            long l3 = l256.getLong3();
            long ptr = mapValue.getLong(this.valueIndex + 1);
            long index = this.setA.of(ptr).keyIndex(l0, l1, l2, l3);
            if (index >= 0L) {
                this.setA.addAt(index, l0, l1, l2, l3);
                mapValue.addLong(this.valueIndex, 1L);
                mapValue.putLong(this.valueIndex + 1, this.setA.ptr());
            }
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public long getLong(Record rec) {
        return rec.getLong(this.valueIndex);
    }

    @Override
    public String getName() {
        return "count_distinct";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcCount = srcValue.getLong(this.valueIndex);
        if (srcCount == 0L || srcCount == Long.MIN_VALUE) {
            return;
        }
        long srcPtr = srcValue.getLong(this.valueIndex + 1);
        long destCount = destValue.getLong(this.valueIndex);
        if (destCount == 0L || destCount == Long.MIN_VALUE) {
            destValue.putLong(this.valueIndex, srcCount);
            destValue.putLong(this.valueIndex + 1, srcPtr);
            return;
        }
        long destPtr = destValue.getLong(this.valueIndex + 1);
        this.setA.of(destPtr);
        this.setB.of(srcPtr);
        if (this.setA.size() > this.setB.size() >>> 1) {
            this.setA.merge(this.setB);
            destValue.putLong(this.valueIndex, this.setA.size());
            destValue.putLong(this.valueIndex + 1, this.setA.ptr());
        } else {
            this.setB.merge(this.setA);
            destValue.putLong(this.valueIndex, this.setB.size());
            destValue.putLong(this.valueIndex + 1, this.setB.ptr());
        }
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.setA.setAllocator(allocator);
        this.setB.setAllocator(allocator);
    }

    @Override
    public void setEmpty(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public void setLong(MapValue mapValue, long value) {
        mapValue.putLong(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putLong(this.valueIndex + 1, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
    }

    private static boolean isNotNull(Long256 value) {
        return value != null && value != Long256Impl.NULL_LONG256 && (value.getLong0() != Long.MIN_VALUE || value.getLong1() != Long.MIN_VALUE || value.getLong2() != Long.MIN_VALUE || value.getLong3() != Long.MIN_VALUE);
    }
}

