/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstUuidGroupByFunction;
import io.questdb.std.Uuid;

public class FirstNotNullUuidGroupByFunction
extends FirstUuidGroupByFunction {
    public FirstNotNullUuidGroupByFunction(Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (Uuid.isNull(mapValue.getLong128Lo(this.valueIndex + 1), mapValue.getLong128Hi(this.valueIndex + 1))) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "first_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcValHi;
        long srcValLo = srcValue.getLong128Lo(this.valueIndex + 1);
        if (Uuid.isNull(srcValLo, srcValHi = srcValue.getLong128Hi(this.valueIndex + 1))) {
            return;
        }
        long srcRowId = srcValue.getLong(this.valueIndex);
        if (srcRowId < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong128(this.valueIndex + 1, srcValLo, srcValHi);
        }
    }
}

