/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.StableAwareUtf8StringHolder;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirstVarcharGroupByFunction
extends VarcharFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function arg;
    protected final StableAwareUtf8StringHolder sink = new StableAwareUtf8StringHolder();
    protected int valueIndex;

    public FirstVarcharGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void clear() {
        this.sink.of(0L);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        Utf8Sequence val = this.arg.getVarcharA(record);
        if (val == null) {
            mapValue.putLong(this.valueIndex + 1, 0L);
            mapValue.putBool(this.valueIndex + 2, true);
        } else {
            this.sink.of(0L).clearAndSet(val);
            mapValue.putLong(this.valueIndex + 1, this.sink.colouredPtr());
            mapValue.putBool(this.valueIndex + 2, false);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharA(Record rec) {
        boolean nullValue = rec.getBool(this.valueIndex + 2);
        if (nullValue) {
            return null;
        }
        long ptr = rec.getLong(this.valueIndex + 1);
        return ptr == 0L ? null : this.sink.of(ptr);
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharB(Record rec) {
        return this.getVarcharA(rec);
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(6);
        columnTypes.add(1);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcRowId = srcValue.getLong(this.valueIndex);
        long destRowId = destValue.getLong(this.valueIndex);
        if (srcRowId != Long.MIN_VALUE && (srcRowId < destRowId || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong(this.valueIndex + 1, srcValue.getLong(this.valueIndex + 1));
            destValue.putBool(this.valueIndex + 2, srcValue.getBool(this.valueIndex + 2));
        }
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.sink.setAllocator(allocator);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putLong(this.valueIndex + 1, 0L);
        mapValue.putBool(this.valueIndex + 2, true);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
    }
}

