/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.LastIPv4GroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class LastNotNullIPv4GroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "last_not_null(X)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends LastIPv4GroupByFunction {
        public Func(@NotNull Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(MapValue mapValue, Record record, long rowId) {
            if (0 != this.arg.getIPv4(record)) {
                this.computeFirst(mapValue, record, rowId);
            }
        }

        @Override
        public String getName() {
            return "last_not_null";
        }

        @Override
        public void merge(MapValue destValue, MapValue srcValue) {
            long destRowId;
            int srcVal = srcValue.getIPv4(this.valueIndex + 1);
            if (srcVal == 0) {
                return;
            }
            long srcRowId = srcValue.getLong(this.valueIndex);
            if (srcRowId > (destRowId = destValue.getLong(this.valueIndex))) {
                destValue.putLong(this.valueIndex, srcRowId);
                destValue.putInt(this.valueIndex + 1, srcVal);
            }
        }
    }
}

