/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class MinIPv4GroupByFunction
extends IPv4Function
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinIPv4GroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putInt(this.valueIndex, this.arg.getIPv4(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        long min = Numbers.ipv4ToLong(mapValue.getIPv4(this.valueIndex));
        long next = Numbers.ipv4ToLong(this.arg.getIPv4(record));
        if (next != 0L && (next < min || min == 0L)) {
            mapValue.putInt(this.valueIndex, (int)next);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getIPv4(Record rec) {
        return rec.getIPv4(this.valueIndex);
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(25);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcMin = Numbers.ipv4ToLong(srcValue.getIPv4(this.valueIndex));
        long destMin = Numbers.ipv4ToLong(destValue.getIPv4(this.valueIndex));
        if (srcMin != 0L && (srcMin < destMin || destMin == 0L)) {
            destValue.putInt(this.valueIndex, (int)srcMin);
        }
    }

    @Override
    public void setInt(MapValue mapValue, int value) {
        mapValue.putInt(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putInt(this.valueIndex, 0);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

