/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.GroupByIntHashSet;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.DirectUtf16Sink;

class StringDistinctAggSymbolGroupByFunction
extends StrFunction
implements UnaryFunction,
GroupByFunction {
    private static final int INITIAL_SINK_CAPACITY = 128;
    private final Function arg;
    private final char delimiter;
    private final GroupByIntHashSet set;
    private final ObjList<DirectUtf16Sink> sinks = new ObjList();
    private int sinkIndex = 0;
    private int valueIndex;

    public StringDistinctAggSymbolGroupByFunction(Function arg, char delimiter, int setInitialCapacity, double setLoadFactor) {
        this.arg = arg;
        this.delimiter = delimiter;
        this.set = new GroupByIntHashSet(setInitialCapacity, setLoadFactor, Integer.MIN_VALUE);
    }

    @Override
    public void clear() {
        Misc.freeObjListAndClear(this.sinks);
        this.sinkIndex = 0;
    }

    @Override
    public void close() {
        Misc.freeObjListAndClear(this.sinks);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        DirectUtf16Sink sink;
        if (this.sinks.size() <= this.sinkIndex) {
            sink = new DirectUtf16Sink(128L);
            this.sinks.extendAndSet(this.sinkIndex, sink);
        } else {
            sink = this.sinks.getQuick(this.sinkIndex);
            sink.clear();
        }
        int key = this.arg.getInt(record);
        if (key != Integer.MIN_VALUE) {
            this.set.of(0L).add(key);
            mapValue.putLong(this.valueIndex, this.set.ptr());
            sink.put(this.arg.getSymbol(record));
        } else {
            mapValue.putLong(this.valueIndex, 0L);
        }
        mapValue.putInt(this.valueIndex + 1, this.sinkIndex++);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        long ptr;
        long index;
        DirectUtf16Sink sink = this.sinks.getQuick(mapValue.getInt(this.valueIndex + 1));
        int key = this.arg.getInt(record);
        if (key != Integer.MIN_VALUE && (index = this.set.of(ptr = mapValue.getLong(this.valueIndex)).keyIndex(key)) >= 0L) {
            if (ptr != 0L) {
                sink.putAscii(this.delimiter);
            }
            this.set.addAt(index, key);
            mapValue.putLong(this.valueIndex, this.set.ptr());
            sink.put(this.arg.getSymbol(record));
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public CharSequence getStrA(Record rec) {
        long ptr = rec.getLong(this.valueIndex);
        if (ptr == 0L) {
            return null;
        }
        return this.sinks.getQuick(rec.getInt(this.valueIndex + 1));
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.getStrA(rec);
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(5);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.set.setAllocator(allocator);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("string_distinct_agg(").val(this.arg).val(',').val(this.delimiter).val(')');
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
        this.sinkIndex = 0;
    }
}

