/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class LtStrIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(SX)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int strFuncPosition = argPositions.getQuick(0);
        Function strFunc = args.getQuick(0);
        Function ipv4Func = args.getQuick(1);
        if (strFunc.isConstant()) {
            int constIPv4 = strFunc.getIPv4(null);
            return new ConstStrFunc(constIPv4, ipv4Func);
        }
        if (strFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(strFunc, ipv4Func);
        }
        throw SqlException.$(strFuncPosition, "STRING constant expected");
    }

    private static class ConstStrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final int constIPv4;

        public ConstStrFunc(int constIPv4, Function arg) {
            this.constIPv4 = constIPv4;
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThanIPv4(this.constIPv4, this.arg.getIPv4(rec), this.negated);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.valIPv4(this.constIPv4);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.arg);
        }
    }

    private static class RuntimeConstStrFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function ipv4Func;
        private final Function strFunc;
        private int constIPv4;

        public RuntimeConstStrFunc(Function strFunc, Function ipv4Func) {
            this.strFunc = strFunc;
            this.ipv4Func = ipv4Func;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThanIPv4(this.constIPv4, this.ipv4Func.getIPv4(rec), this.negated);
        }

        @Override
        public Function getLeft() {
            return this.ipv4Func;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            this.constIPv4 = this.strFunc.getIPv4(null);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.strFunc);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.ipv4Func);
        }
    }
}

