/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.DoubleConstant;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class RoundHalfEvenDoubleFunctionFactory
implements FunctionFactory {
    private static final String SYMBOL = "round_half_even";
    private static final String SIGNATURE = "round_half_even(DI)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function scale = args.getQuick(1);
        if (scale.isConstant()) {
            int scaleValue = scale.getInt(null);
            if (scaleValue != Integer.MIN_VALUE) {
                if (scaleValue > -1 && scaleValue + 2 < Numbers.pow10max) {
                    return new FuncPosConst(args.getQuick(0), scaleValue);
                }
                if (scaleValue < 0 && scaleValue > -Numbers.pow10max) {
                    return new FuncNegConst(args.getQuick(0), -scaleValue);
                }
            }
            return DoubleConstant.NULL;
        }
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class FuncPosConst
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;
        private final int scale;

        public FuncPosConst(Function arg, int r) {
            this.arg = arg;
            this.scale = r;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.arg.getDouble(rec);
            if (Numbers.isNull(l)) {
                return l;
            }
            return Numbers.roundHalfEvenPosScale(l, this.scale);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RoundHalfEvenDoubleFunctionFactory.SYMBOL).val('(').val(this.arg).val(',').val(this.scale).val(')');
        }
    }

    private static class FuncNegConst
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arg;
        private final int scale;

        public FuncNegConst(Function arg, int r) {
            this.arg = arg;
            this.scale = r;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.arg.getDouble(rec);
            if (Numbers.isNull(l)) {
                return l;
            }
            return Numbers.roundHalfEvenNegScale(l, this.scale);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(RoundHalfEvenDoubleFunctionFactory.SYMBOL).val('(').val(this.arg).val(',').val(this.scale).val(')');
        }
    }

    private static class Func
    extends DoubleFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public double getDouble(Record rec) {
            double l = this.left.getDouble(rec);
            if (Numbers.isNull(l)) {
                return l;
            }
            int r = this.right.getInt(rec);
            if (r == Integer.MIN_VALUE) {
                return Double.NaN;
            }
            try {
                return Numbers.roundHalfEven(l, r);
            }
            catch (NumericException e) {
                return Double.NaN;
            }
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public String getName() {
            return RoundHalfEvenDoubleFunctionFactory.SYMBOL;
        }

        @Override
        public Function getRight() {
            return this.right;
        }
    }
}

