/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.memoization;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NullRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CharFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

public final class CharFunctionMemoizer
extends CharFunction
implements UnaryFunction {
    private final Function fn;
    private Record recordLeft;
    private Record recordRight;
    private char valueLeft;
    private char valueRight;

    public CharFunctionMemoizer(Function fn) {
        assert (fn.shouldMemoize());
        this.fn = fn;
    }

    @Override
    public Function getArg() {
        return this.fn;
    }

    @Override
    public char getChar(Record rec) {
        if (this.recordLeft == rec) {
            return this.valueLeft;
        }
        if (this.recordRight == rec) {
            return this.valueRight;
        }
        return this.fn.getChar(rec);
    }

    @Override
    public String getName() {
        return "memoize";
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.recordLeft = NullRecord.INSTANCE;
        this.recordRight = NullRecord.INSTANCE;
        UnaryFunction.super.init(symbolTableSource, executionContext);
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void memoize(Record record) {
        if (this.recordLeft == record) {
            this.valueLeft = this.fn.getChar(record);
        } else if (this.recordRight == record) {
            this.valueRight = this.fn.getChar(record);
        } else if (this.recordLeft == NullRecord.INSTANCE) {
            this.recordLeft = record;
            this.valueLeft = this.fn.getChar(record);
        } else if (this.recordRight == NullRecord.INSTANCE) {
            assert (this.supportsRandomAccess());
            this.recordRight = record;
            this.valueRight = this.fn.getChar(record);
        } else {
            throw CairoException.nonCritical().put("CharFunctionMemoizer can only memoize two records, but got more than two: [recordLeft=").put(this.recordLeft.toString()).put(", recordRight=").put(this.recordRight.toString()).put(", newRecord=").put(record.toString()).put(']');
        }
    }

    @Override
    public boolean shouldMemoize() {
        return true;
    }

    @Override
    public boolean supportsRandomAccess() {
        return this.fn.supportsRandomAccess();
    }
}

