/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.ByteFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Rnd;

public class RndByteCCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "rnd_byte(ii)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        byte hi;
        byte lo = (byte)args.getQuick(0).getInt(null);
        if (lo < (hi = (byte)args.getQuick(1).getInt(null))) {
            return new RndFunction(lo, hi);
        }
        throw SqlException.position(position).put("invalid range");
    }

    private static class RndFunction
    extends ByteFunction
    implements Function {
        private final byte lo;
        private final byte range;
        private Rnd rnd;

        public RndFunction(byte lo, byte hi) {
            this.lo = lo;
            this.range = (byte)(hi - lo + 1);
        }

        @Override
        public byte getByte(Record rec) {
            short s = this.rnd.nextShort();
            if (s < 0) {
                return (byte)(this.lo - s % this.range);
            }
            return (byte)(this.lo + s % this.range);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
            this.rnd = executionContext.getRandom();
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("rnd_byte(").val(this.lo).val(',').val(this.range).val(')');
        }
    }
}

