/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.engine.functions.table.ReadParquetRecordCursor;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.str.LPSZ;
import org.jetbrains.annotations.Nullable;

public class ReadParquetPageFrameCursor
implements PageFrameCursor {
    private static final Log LOG = LogFactory.getLog(ReadParquetPageFrameCursor.class);
    private final IntList columnIndexes;
    private final PartitionDecoder decoder;
    private final FilesFacade ff;
    private final ReadParquetPageFrame frame = new ReadParquetPageFrame();
    private final RecordMetadata metadata;
    private long addr = 0L;
    private long fd = -1L;
    private long fileSize = 0L;
    private long rowCount;
    private int rowGroupCount;

    public ReadParquetPageFrameCursor(FilesFacade ff, RecordMetadata metadata) {
        this.ff = ff;
        this.metadata = metadata;
        this.decoder = new PartitionDecoder();
        this.columnIndexes = new IntList();
    }

    @Override
    public void calculateSize(RecordCursor.Counter counter) {
        counter.add(this.rowCount);
    }

    @Override
    public void close() {
        Misc.free(this.decoder);
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            this.fd = -1L;
        }
        if (this.addr != 0L) {
            this.ff.munmap(this.addr, this.fileSize, 17);
            this.addr = 0L;
        }
    }

    @Override
    public IntList getColumnIndexes() {
        return this.columnIndexes;
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return null;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return null;
    }

    @Override
    @Nullable
    public PageFrame next(long skipTarget) {
        int rowGroupIndex;
        if ((rowGroupIndex = ++this.frame.rowGroupIndex) < this.rowGroupCount) {
            this.frame.rowGroupSize = this.decoder.metadata().rowGroupSize(rowGroupIndex);
            this.frame.partitionLo = this.frame.partitionHi;
            this.frame.partitionHi += (long)this.frame.rowGroupSize;
            return this.frame;
        }
        return null;
    }

    public void of(LPSZ path) {
        this.fd = TableUtils.openRO(this.ff, path, LOG);
        this.fileSize = this.ff.length(this.fd);
        this.addr = TableUtils.mapRO(this.ff, this.fd, this.fileSize, 17);
        this.decoder.of(this.addr, this.fileSize, 65);
        if (ReadParquetRecordCursor.metadataHasChanged(this.metadata, this.decoder)) {
            throw TableReferenceOutOfDateException.of(path);
        }
        this.columnIndexes.clear();
        int n = this.metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.columnIndexes.add(i);
        }
        this.rowCount = this.decoder.metadata().rowCount();
        this.rowGroupCount = this.decoder.metadata().rowGroupCount();
        this.toTop();
    }

    @Override
    public long size() throws DataUnavailableException {
        return this.rowCount;
    }

    @Override
    public boolean supportsSizeCalculation() {
        return true;
    }

    @Override
    public void toTop() {
        this.frame.clear();
    }

    private class ReadParquetPageFrame
    implements PageFrame,
    Mutable {
        private long partitionHi;
        private long partitionLo;
        private int rowGroupIndex;
        private int rowGroupSize;

        private ReadParquetPageFrame() {
        }

        @Override
        public void clear() {
            this.rowGroupIndex = -1;
            this.rowGroupSize = 0;
            this.partitionLo = 0L;
            this.partitionHi = 0L;
        }

        @Override
        public long getAuxPageAddress(int columnIndex) {
            return 0L;
        }

        @Override
        public long getAuxPageSize(int columnIndex) {
            return 0L;
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return ReadParquetPageFrameCursor.this.columnIndexes.size();
        }

        @Override
        public byte getFormat() {
            return 1;
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return 0L;
        }

        @Override
        public long getPageSize(int columnIndex) {
            return 0L;
        }

        @Override
        public long getParquetAddr() {
            return ReadParquetPageFrameCursor.this.addr;
        }

        @Override
        public long getParquetFileSize() {
            return ReadParquetPageFrameCursor.this.fileSize;
        }

        @Override
        public int getParquetRowGroup() {
            return this.rowGroupIndex;
        }

        @Override
        public int getParquetRowGroupHi() {
            return this.rowGroupSize;
        }

        @Override
        public int getParquetRowGroupLo() {
            return 0;
        }

        @Override
        public long getPartitionHi() {
            return this.partitionHi;
        }

        @Override
        public int getPartitionIndex() {
            return 0;
        }

        @Override
        public long getPartitionLo() {
            return this.partitionLo;
        }
    }
}

