/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.functions.constants.LongConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class TestAllocatingFunctionFactory
implements FunctionFactory {
    private static final long MAX_BYTES = 0x100000L;

    @Override
    public String getSignature() {
        return "alloc(l)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (configuration.isDevModeEnabled()) {
            long bytes = args.getQuick(0).getLong(null);
            if (bytes > 0x100000L) {
                throw SqlException.$(argPositions.getQuick(0), "too much to allocate: ").put(bytes);
            }
            return new Func(bytes);
        }
        return LongConstant.ZERO;
    }

    private static class Func
    extends LongFunction {
        private final long allocSize;
        private long addr;

        public Func(long allocSize) {
            this.addr = Unsafe.malloc(allocSize, 19);
            this.allocSize = allocSize;
        }

        @Override
        public void close() {
            this.addr = Unsafe.free(this.addr, this.allocSize, 19);
        }

        @Override
        public long getLong(Record rec) {
            return 42L;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("alloc(").val(this.allocSize).val(')');
        }
    }
}

