/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import java.util.concurrent.atomic.AtomicLong;

public class TestTimestampCounterFactory
implements FunctionFactory {
    public static final AtomicLong COUNTER = new AtomicLong();
    private static final String NAME = "test_timestamp_counter";

    @Override
    public String getSignature() {
        return "test_timestamp_counter(N)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function tsFunc = args.getQuick(0);
        if (configuration.isDevModeEnabled()) {
            return new Func(tsFunc);
        }
        return tsFunc;
    }

    private static class Func
    extends TimestampFunction
    implements UnaryFunction {
        private final Function tsFunc;

        private Func(Function tsFunc) {
            this.tsFunc = tsFunc;
        }

        @Override
        public Function getArg() {
            return this.tsFunc;
        }

        @Override
        public long getTimestamp(Record rec) {
            COUNTER.incrementAndGet();
            return this.tsFunc.getTimestamp(rec);
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TestTimestampCounterFactory.NAME);
        }
    }
}

