/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.uuid;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.UuidFunction;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public final class LongsToUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "to_uuid(LL)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function loLong = args.getQuick(0);
        Function hiLong = args.getQuick(1);
        if (loLong.isConstant() && hiLong.isConstant()) {
            return new UuidConstant(loLong.getLong(null), hiLong.getLong(null));
        }
        return new LongsToUuidFunction(loLong, hiLong);
    }

    private static class LongsToUuidFunction
    extends UuidFunction
    implements BinaryFunction {
        private final Function hi;
        private final Function lo;

        public LongsToUuidFunction(Function loLong, Function hiLong) {
            this.lo = loLong;
            this.hi = hiLong;
        }

        @Override
        public Function getLeft() {
            return this.lo;
        }

        @Override
        public long getLong128Hi(Record rec) {
            return this.hi.getLong(rec);
        }

        @Override
        public long getLong128Lo(Record rec) {
            return this.lo.getLong(rec);
        }

        @Override
        public String getName() {
            return "to_uuid";
        }

        @Override
        public Function getRight() {
            return this.hi;
        }
    }
}

