/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.MaxDoubleWindowFunctionFactory;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class MinDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final MaxDoubleWindowFunctionFactory.DoubleComparator LESS_THAN = (a, b) -> Numbers.compare(a, b) < 0;
    public static final String NAME = "min";
    private static final String SIGNATURE = "min(D)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, framingMode == 1, partitionByRecord);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MaxDoubleWindowFunctionFactory.MAX_COLUMN_TYPES);
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), LESS_THAN, NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MaxDoubleWindowFunctionFactory.MAX_COLUMN_TYPES);
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), LESS_THAN, NAME);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = null;
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, rowsLo == Long.MIN_VALUE ? MaxDoubleWindowFunctionFactory.MAX_OVER_PARTITION_RANGE_COLUMN_TYPES : MaxDoubleWindowFunctionFactory.MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, dequeMem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex, LESS_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MaxDoubleWindowFunctionFactory.MAX_COLUMN_TYPES);
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), LESS_THAN, NAME);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverCurrentRowFunction(args.get(0), NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MaxDoubleWindowFunctionFactory.MAX_COLUMN_TYPES);
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), LESS_THAN, NAME);
                }
                Map map = null;
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, rowsLo == Long.MIN_VALUE ? MaxDoubleWindowFunctionFactory.MAX_OVER_PARTITION_ROWS_COLUMN_TYPES : MaxDoubleWindowFunctionFactory.MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, dequeMem, LESS_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverWholeResultSetFunction(args.get(0), LESS_THAN, NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverUnboundedRowsFrameFunction(args.get(0), LESS_THAN, NAME);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, mem, dequeMem, timestampIndex, LESS_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverUnboundedRowsFrameFunction(args.get(0), LESS_THAN, NAME);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverCurrentRowFunction(args.get(0), NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new MaxDoubleWindowFunctionFactory.MaxMinOverWholeResultSetFunction(args.get(0), LESS_THAN, NAME);
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                MemoryCARW dequeMem = null;
                if (rowsLo != Long.MIN_VALUE) {
                    dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                }
                return new MaxDoubleWindowFunctionFactory.MaxMinOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem, dequeMem, LESS_THAN, NAME);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }
}

