/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.TimestampSampler;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.microtime.Timestamps;
import java.io.Closeable;

public abstract class AbstractSampleByCursor
implements NoRandomAccessRecordCursor,
Closeable {
    protected final Function offsetFunc;
    protected final int offsetFuncPos;
    protected final Function sampleFromFunc;
    protected final int sampleFromFuncPos;
    protected final Function sampleToFunc;
    protected final int sampleToFuncPos;
    protected final TimestampSampler timestampSampler;
    protected final Function timezoneNameFunc;
    protected final int timezoneNameFuncPos;
    protected long fixedOffset;
    protected long localEpoch;
    protected long nextDstUtc;
    protected long prevDst;
    protected TimeZoneRules rules;
    protected long tzOffset;

    public AbstractSampleByCursor(TimestampSampler timestampSampler, Function timezoneNameFunc, int timezoneNameFuncPos, Function offsetFunc, int offsetFuncPos, Function sampleFromFunc, int sampleFromFuncPos, Function sampleToFunc, int sampleToFuncPos) {
        this.timestampSampler = timestampSampler;
        this.timezoneNameFunc = timezoneNameFunc;
        this.timezoneNameFuncPos = timezoneNameFuncPos;
        this.offsetFunc = offsetFunc;
        this.offsetFuncPos = offsetFuncPos;
        this.sampleFromFunc = sampleFromFunc;
        this.sampleFromFuncPos = sampleFromFuncPos;
        this.sampleToFunc = sampleToFunc;
        this.sampleToFuncPos = sampleToFuncPos;
    }

    @Override
    public void close() {
        Misc.free(this.timezoneNameFunc);
        Misc.free(this.offsetFunc);
    }

    protected void parseParams(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        this.timezoneNameFunc.init(base, executionContext);
        this.offsetFunc.init(base, executionContext);
        this.rules = null;
        CharSequence tz = this.timezoneNameFunc.getStrA(null);
        if (tz != null) {
            try {
                long opt = Timestamps.parseOffset(tz);
                if (opt == Long.MIN_VALUE) {
                    this.rules = TimestampFormatUtils.EN_LOCALE.getZoneRules(Numbers.decodeLowInt(TimestampFormatUtils.EN_LOCALE.matchZone(tz, 0, tz.length())), 1);
                }
                this.tzOffset = (long)Numbers.decodeLowInt(opt) * 60000000L;
                this.nextDstUtc = Long.MAX_VALUE;
            }
            catch (NumericException e) {
                throw SqlException.$(this.timezoneNameFuncPos, "invalid timezone: ").put(tz);
            }
        } else {
            this.tzOffset = 0L;
            this.nextDstUtc = Long.MAX_VALUE;
        }
        CharSequence offset = this.offsetFunc.getStrA(null);
        if (offset != null) {
            long val = Timestamps.parseOffset(offset);
            if (val == Long.MIN_VALUE) {
                throw SqlException.$(this.offsetFuncPos, "invalid offset: ").put(offset);
            }
            this.fixedOffset = (long)Numbers.decodeLowInt(val) * 60000000L;
        } else {
            this.fixedOffset = Long.MIN_VALUE;
        }
    }
}

