/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import java.util.concurrent.atomic.LongAdder;

public abstract class AbstractCountVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    protected final LongAdder aggCount = new LongAdder();
    protected final LongAdder count = new LongAdder();
    private final int columnIndex;
    protected DistinctFunc distinctFunc;
    protected KeyValueFunc keyValueFunc;
    protected int valueOffset;

    public AbstractCountVectorAggregateFunction(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    @Override
    public void clear() {
        this.count.reset();
        this.aggCount.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getLong(Record rec) {
        return this.count.sum();
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntCountMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(6);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("count(").putBaseColumnName(this.columnIndex).val(')');
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntCountWrapUp(pRosti, this.valueOffset, this.aggCount.sum() > 0L ? this.count.sum() : Long.MIN_VALUE);
    }
}

