/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameAddressCache;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.cairo.sql.async.WorkStealingStrategy;
import io.questdb.cairo.sql.async.WorkStealingStrategyFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.PerWorkerLocks;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateEntry;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Worker;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Os;
import io.questdb.tasks.VectorAggregateTask;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupByNotKeyedVectorRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final Log LOG = LogFactory.getLog(GroupByNotKeyedVectorRecordCursorFactory.class);
    private final RecordCursorFactory base;
    private final GroupByNotKeyedVectorRecordCursor cursor;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final ObjectPool<VectorAggregateEntry> entryPool;
    private final PageFrameAddressCache frameAddressCache;
    private final ObjList<PageFrameMemoryPool> frameMemoryPools;
    private final PerWorkerLocks perWorkerLocks;
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker;
    private final AtomicInteger startedCounter = new AtomicInteger();
    private final ObjList<VectorAggregateFunction> vafList;
    private final WorkStealingStrategy workStealingStrategy;
    private final int workerCount;

    public GroupByNotKeyedVectorRecordCursorFactory(CairoConfiguration configuration, RecordCursorFactory base, RecordMetadata metadata, int workerCount, ObjList<VectorAggregateFunction> vafList) {
        super(metadata);
        try {
            this.base = base;
            this.frameAddressCache = new PageFrameAddressCache(configuration);
            this.entryPool = new ObjectPool<VectorAggregateEntry>(VectorAggregateEntry::new, configuration.getGroupByPoolCapacity());
            this.vafList = new ObjList(vafList.size());
            this.vafList.addAll(vafList);
            this.cursor = new GroupByNotKeyedVectorRecordCursor(this.vafList);
            this.workerCount = workerCount;
            this.perWorkerLocks = new PerWorkerLocks(configuration, workerCount);
            this.sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
            this.workStealingStrategy = WorkStealingStrategyFactory.getInstance(configuration, workerCount);
            this.workStealingStrategy.of(this.startedCounter);
            this.frameMemoryPools = new ObjList(workerCount);
            for (int i = 0; i < workerCount; ++i) {
                this.frameMemoryPools.add(new PageFrameMemoryPool(1));
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int n = this.vafList.size();
        for (int i = 0; i < n; ++i) {
            this.vafList.getQuick(i).clear();
        }
        PageFrameCursor frameCursor = this.base.getPageFrameCursor(executionContext, 0);
        return this.cursor.of(this.base.getMetadata(), frameCursor, executionContext.getMessageBus(), executionContext.getCircuitBreaker());
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(true);
        sink.meta("workers").val(this.workerCount);
        sink.optAttr((CharSequence)"values", this.vafList, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    static int runWhatsLeft(MCSequence subSeq, RingQueue<VectorAggregateTask> queue, int queuedCount, int reclaimed, int mergedCount, int workerId, SOUnboundedCountDownLatch doneLatch, SqlExecutionCircuitBreaker circuitBreaker, AtomicBooleanCircuitBreaker sharedCB, WorkStealingStrategy workStealingStrategy) {
        while (!doneLatch.done(queuedCount)) {
            if (circuitBreaker.checkIfTripped()) {
                sharedCB.cancel();
            }
            if (workStealingStrategy.shouldSteal(mergedCount)) {
                long cursor = subSeq.next();
                if (cursor > -1L) {
                    VectorAggregateTask task = queue.get(cursor);
                    task.entry.run(workerId, subSeq, cursor);
                    ++reclaimed;
                } else {
                    Os.pause();
                }
            }
            mergedCount = doneLatch.getCount();
        }
        return reclaimed;
    }

    @Override
    protected void _close() {
        Misc.freeObjListAndKeepObjects(this.frameMemoryPools);
        Misc.freeObjList(this.vafList);
        Misc.free(this.base);
    }

    private class GroupByNotKeyedVectorRecordCursor
    implements NoRandomAccessRecordCursor {
        private final Record recordA;
        private boolean areFunctionsBuilt;
        private MessageBus bus;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private int countDown = 1;
        private int frameCount;
        private PageFrameCursor frameCursor;

        public GroupByNotKeyedVectorRecordCursor(ObjList<? extends Function> functions) {
            this.recordA = new VirtualRecordNoRowid(functions);
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            if (this.countDown > 0) {
                counter.add(this.countDown);
                this.countDown = 0;
            }
        }

        @Override
        public void close() {
            GroupByNotKeyedVectorRecordCursorFactory.this.frameAddressCache.clear();
            this.frameCursor = Misc.free(this.frameCursor);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            if (!this.areFunctionsBuilt) {
                this.buildFunctions();
                this.areFunctionsBuilt = true;
            }
            return this.countDown-- > 0;
        }

        public GroupByNotKeyedVectorRecordCursor of(RecordMetadata metadata, PageFrameCursor frameCursor, MessageBus bus, SqlExecutionCircuitBreaker circuitBreaker) {
            this.frameCursor = frameCursor;
            this.bus = bus;
            this.circuitBreaker = circuitBreaker;
            GroupByNotKeyedVectorRecordCursorFactory.this.frameAddressCache.of(metadata, frameCursor.getColumnIndexes());
            for (int i = 0; i < GroupByNotKeyedVectorRecordCursorFactory.this.workerCount; ++i) {
                GroupByNotKeyedVectorRecordCursorFactory.this.frameMemoryPools.getQuick(i).of(GroupByNotKeyedVectorRecordCursorFactory.this.frameAddressCache);
            }
            this.frameCount = 0;
            this.areFunctionsBuilt = false;
            this.toTop();
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return RecordCursor.fromBool(this.areFunctionsBuilt);
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.countDown = 1;
        }

        private void buildFunctions() {
            int vafCount = GroupByNotKeyedVectorRecordCursorFactory.this.vafList.size();
            RingQueue<VectorAggregateTask> queue = this.bus.getVectorAggregateQueue();
            MPSequence pubSeq = this.bus.getVectorAggregatePubSeq();
            GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker.reset();
            GroupByNotKeyedVectorRecordCursorFactory.this.startedCounter.set(0);
            GroupByNotKeyedVectorRecordCursorFactory.this.entryPool.clear();
            int queuedCount = 0;
            int ownCount = 0;
            int reclaimed = 0;
            int total = 0;
            int mergedCount = 0;
            GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch.reset();
            Thread thread = Thread.currentThread();
            int workerId = thread instanceof Worker ? ((Worker)thread).getWorkerId() % GroupByNotKeyedVectorRecordCursorFactory.this.workerCount : -1;
            try {
                PageFrame frame;
                while ((frame = this.frameCursor.next()) != null) {
                    GroupByNotKeyedVectorRecordCursorFactory.this.frameAddressCache.add(this.frameCount++, frame);
                }
                for (int frameIndex = 0; frameIndex < this.frameCount; ++frameIndex) {
                    long frameRowCount = GroupByNotKeyedVectorRecordCursorFactory.this.frameAddressCache.getFrameSize(frameIndex);
                    block8: for (int vafIndex = 0; vafIndex < vafCount; ++vafIndex) {
                        long cursor;
                        VectorAggregateFunction vaf = GroupByNotKeyedVectorRecordCursorFactory.this.vafList.getQuick(vafIndex);
                        int columnIndex = vaf.getColumnIndex();
                        while ((cursor = pubSeq.next()) < 0L) {
                            this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                            if (GroupByNotKeyedVectorRecordCursorFactory.this.workStealingStrategy.shouldSteal(mergedCount)) {
                                VectorAggregateEntry.aggregateUnsafe(workerId, null, frameIndex, frameRowCount, -1, columnIndex, null, GroupByNotKeyedVectorRecordCursorFactory.this.frameMemoryPools, null, vaf, GroupByNotKeyedVectorRecordCursorFactory.this.perWorkerLocks, this.circuitBreaker);
                                ++ownCount;
                                ++total;
                                mergedCount = GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch.getCount();
                                continue block8;
                            }
                            mergedCount = GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch.getCount();
                        }
                        VectorAggregateEntry entry = GroupByNotKeyedVectorRecordCursorFactory.this.entryPool.next();
                        entry.of(frameIndex, frameRowCount, -1, columnIndex, vaf, null, GroupByNotKeyedVectorRecordCursorFactory.this.frameMemoryPools, GroupByNotKeyedVectorRecordCursorFactory.this.startedCounter, GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch, null, null, GroupByNotKeyedVectorRecordCursorFactory.this.perWorkerLocks, GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker);
                        queue.get((long)cursor).entry = entry;
                        pubSeq.done(cursor);
                        ++queuedCount;
                        ++total;
                    }
                }
                this.circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
            }
            catch (DataUnavailableException e) {
                throw e;
            }
            catch (Throwable e) {
                GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker.cancel();
                Misc.freeObjListAndKeepObjects(GroupByNotKeyedVectorRecordCursorFactory.this.frameMemoryPools);
                throw e;
            }
            finally {
                reclaimed = GroupByNotKeyedVectorRecordCursorFactory.runWhatsLeft(this.bus.getVectorAggregateSubSeq(), queue, queuedCount, reclaimed, mergedCount, workerId, GroupByNotKeyedVectorRecordCursorFactory.this.doneLatch, this.circuitBreaker, GroupByNotKeyedVectorRecordCursorFactory.this.sharedCircuitBreaker, GroupByNotKeyedVectorRecordCursorFactory.this.workStealingStrategy);
            }
            Misc.freeObjListAndKeepObjects(GroupByNotKeyedVectorRecordCursorFactory.this.frameMemoryPools);
            this.toTop();
            LOG.info().$("done [total=").$(total).$(", ownCount=").$(ownCount).$(", reclaimed=").$(reclaimed).$(", queuedCount=").$(queuedCount).I$();
        }
    }
}

