/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.griffin.engine.join.SymbolShortCircuit;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;

public final class SingleVarcharSymbolShortCircuit
implements SymbolShortCircuit {
    private final int masterVarcharIndex;
    private final int slaveSymbolIndex;
    private final StringSink utf16Sink = new StringSink();
    private StaticSymbolTable slaveSymbolTable;

    public SingleVarcharSymbolShortCircuit(int masterVarcharIndex, int slaveSymbolIndex) {
        this.masterVarcharIndex = masterVarcharIndex;
        this.slaveSymbolIndex = slaveSymbolIndex;
    }

    @Override
    public boolean isShortCircuit(Record masterRecord) {
        Utf8Sequence masterVarchar = masterRecord.getVarcharA(this.masterVarcharIndex);
        if (masterVarchar == null) {
            return this.slaveSymbolTable.containsNullValue();
        }
        if (masterVarchar.isAscii()) {
            return this.slaveSymbolTable.keyOf(masterVarchar.asAsciiCharSequence()) == -2;
        }
        this.utf16Sink.clear();
        this.utf16Sink.put(masterVarchar);
        return this.slaveSymbolTable.keyOf(this.utf16Sink) == -2;
    }

    @Override
    public void of(TimeFrameRecordCursor slaveCursor) {
        this.slaveSymbolTable = slaveCursor.getSymbolTable(this.slaveSymbolIndex);
    }
}

