/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.orderby.LongTopKRecordCursor;
import io.questdb.std.Misc;

public class LongTopKRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final boolean ascending;
    private final RecordCursorFactory base;
    private final int columnIndex;
    private final LongTopKRecordCursor cursor;
    private final int lo;

    public LongTopKRecordCursorFactory(RecordMetadata metadata, RecordCursorFactory base, int columnIndex, int lo, boolean ascending) {
        super(metadata);
        assert (lo > 0);
        assert (base.recordCursorSupportsLongTopK());
        this.base = base;
        this.columnIndex = columnIndex;
        this.lo = lo;
        this.ascending = ascending;
        this.cursor = new LongTopKRecordCursor(columnIndex, lo, ascending);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            Misc.free(this.cursor);
            throw th;
        }
    }

    @Override
    public int getScanDirection() {
        return this.ascending ? 1 : 2;
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Long Top K");
        sink.meta("lo").val(this.lo);
        sink.attr("keys").val('[');
        sink.putBaseColumnName(this.columnIndex);
        sink.val(" ");
        if (this.ascending) {
            sink.val("asc");
        } else {
            sink.val("desc");
        }
        sink.val(']');
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.cursor);
    }
}

