/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRandomRecordCursor;
import io.questdb.griffin.engine.EmptyTableRecordCursor;
import io.questdb.griffin.engine.table.AbstractLatestByValueRecordCursor;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDeferredValueRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    protected final int columnIndex;
    protected final IntList columnIndexes;
    private final Function symbolFunc;
    protected Function filter;
    private AbstractLatestByValueRecordCursor cursor;

    public AbstractDeferredValueRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, int columnIndex, Function symbolFunc, @Nullable Function filter, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        this.columnIndex = columnIndex;
        this.symbolFunc = symbolFunc;
        this.filter = filter;
        this.columnIndexes = columnIndexes;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.optAttr((CharSequence)"filter", this.filter);
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolFunc);
        sink.child(this.partitionFrameCursorFactory);
    }

    private boolean lookupDeferredSymbol(PageFrameCursor pageFrameCursor) {
        CharSequence symbol = this.symbolFunc.getStrA(null);
        int newSymbolKey = pageFrameCursor.getSymbolTable(this.columnIndex).keyOf(symbol);
        if (newSymbolKey == -2) {
            pageFrameCursor.close();
            return true;
        }
        if (this.cursor != null) {
            this.cursor.setSymbolKey(newSymbolKey);
        } else {
            this.cursor = this.createCursorFor(newSymbolKey);
        }
        return false;
    }

    @Override
    protected void _close() {
        super._close();
        this.filter = Misc.free(this.filter);
        Misc.free(this.cursor);
    }

    protected abstract AbstractLatestByValueRecordCursor createCursorFor(int var1);

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.symbolFunc.init(pageFrameCursor, executionContext);
        if (this.lookupDeferredSymbol(pageFrameCursor)) {
            if (this.recordCursorSupportsRandomAccess()) {
                return EmptyTableRandomRecordCursor.INSTANCE;
            }
            return EmptyTableRecordCursor.INSTANCE;
        }
        this.cursor.of(pageFrameCursor, executionContext);
        return this.cursor;
    }
}

