/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursor;

public class LatestByValueIndexedRowCursorFactory
implements RowCursorFactory {
    private final boolean cachedIndexReaderCursor;
    private final int columnIndex;
    private final LatestByValueIndexedRowCursor cursor = new LatestByValueIndexedRowCursor();
    private final int symbolKey;

    public LatestByValueIndexedRowCursorFactory(int columnIndex, int symbolKey, boolean cachedIndexReaderCursor) {
        this.columnIndex = columnIndex;
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
    }

    @Override
    public RowCursor getCursor(PageFrame pageFrame, PageFrameMemory pageFrameMemory) {
        RowCursor indexReaderCursor = pageFrame.getBitmapIndexReader(this.columnIndex, 2).getCursor(this.cachedIndexReaderCursor, this.symbolKey, pageFrame.getPartitionLo(), pageFrame.getPartitionHi() - 1L);
        if (indexReaderCursor.hasNext()) {
            this.cursor.of(indexReaderCursor.next());
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public boolean isUsingIndex() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index ").type("backward").type(" scan").meta("on").putBaseColumnName(this.columnIndex);
        sink.attr("filter").putBaseColumnName(this.columnIndex).val('=').val(this.symbolKey);
    }
}

