/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.TimeFrame;
import io.questdb.cairo.sql.TimeFrameRecordCursor;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.SelectedRecord;
import io.questdb.griffin.engine.table.SelectedRecordCursor;
import io.questdb.jit.CompiledFilter;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.Nullable;

public final class SelectedRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final IntList columnCrossIndex;
    private final boolean crossedIndex;
    private final SelectedRecordCursor cursor;
    private SelectedPageFrameCursor pageFrameCursor;
    private SelectedTimeFrameCursor timeFrameCursor;

    public SelectedRecordCursorFactory(RecordMetadata metadata, IntList columnCrossIndex, RecordCursorFactory base) {
        super(metadata);
        this.base = base;
        this.columnCrossIndex = columnCrossIndex;
        this.cursor = new SelectedRecordCursor(columnCrossIndex, base.recordCursorSupportsRandomAccess());
        this.crossedIndex = SelectedRecordCursorFactory.isCrossedIndex(columnCrossIndex);
    }

    public static boolean isCrossedIndex(IntList columnCrossIndex) {
        int n = columnCrossIndex.size();
        for (int i = 0; i < n; ++i) {
            if (columnCrossIndex.get(i) == i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.base.followedLimitAdvice();
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    @Nullable
    public ObjList<Function> getBindVarFunctions() {
        return this.base.getBindVarFunctions();
    }

    @Override
    @Nullable
    public MemoryCARW getBindVarMemory() {
        return this.base.getBindVarMemory();
    }

    @Override
    public IntList getColumnCrossIndex() {
        return this.columnCrossIndex;
    }

    @Override
    public CompiledFilter getCompiledFilter() {
        return this.base.getCompiledFilter();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        if (!this.crossedIndex) {
            return baseCursor;
        }
        try {
            this.cursor.of(baseCursor);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public Function getFilter() {
        return this.base.getFilter();
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        PageFrameCursor baseCursor = this.base.getPageFrameCursor(executionContext, order);
        if (baseCursor == null || !this.crossedIndex) {
            return baseCursor;
        }
        if (this.pageFrameCursor == null) {
            this.pageFrameCursor = new SelectedPageFrameCursor(this.columnCrossIndex);
        }
        return this.pageFrameCursor.wrap(baseCursor);
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public TimeFrameRecordCursor getTimeFrameCursor(SqlExecutionContext executionContext) throws SqlException {
        TimeFrameRecordCursor baseCursor = this.base.getTimeFrameCursor(executionContext);
        if (baseCursor == null || !this.crossedIndex) {
            return baseCursor;
        }
        if (this.timeFrameCursor == null) {
            this.timeFrameCursor = new SelectedTimeFrameCursor(this.columnCrossIndex, this.base.recordCursorSupportsRandomAccess());
        }
        return this.timeFrameCursor.of(baseCursor);
    }

    @Override
    public void halfClose() {
        this.base.halfClose();
    }

    @Override
    public boolean implementsLimit() {
        return this.base.implementsLimit();
    }

    @Override
    public boolean isProjection() {
        return true;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public boolean supportsPageFrameCursor() {
        return this.base.supportsPageFrameCursor();
    }

    @Override
    public boolean supportsTimeFrameCursor() {
        return this.base.supportsTimeFrameCursor();
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("SelectedRecord");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        this.base.close();
    }

    private static class SelectedPageFrameCursor
    implements PageFrameCursor {
        private final IntList columnCrossIndex;
        private final SelectedPageFrame pageFrame;
        private PageFrameCursor baseCursor;

        private SelectedPageFrameCursor(IntList columnCrossIndex) {
            this.columnCrossIndex = columnCrossIndex;
            this.pageFrame = new SelectedPageFrame(columnCrossIndex);
        }

        @Override
        public void calculateSize(RecordCursor.Counter counter) {
            this.baseCursor.calculateSize(counter);
        }

        @Override
        public void close() {
            this.baseCursor.close();
        }

        @Override
        public IntList getColumnIndexes() {
            return this.baseCursor.getColumnIndexes();
        }

        @Override
        public StaticSymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        @Nullable
        public PageFrame next(long skipTarget) {
            PageFrame baseFrame = this.baseCursor.next(skipTarget);
            return baseFrame != null ? this.pageFrame.of(baseFrame) : null;
        }

        @Override
        public long size() {
            return this.baseCursor.size();
        }

        @Override
        public boolean supportsSizeCalculation() {
            return this.baseCursor.supportsSizeCalculation();
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
        }

        public SelectedPageFrameCursor wrap(PageFrameCursor baseCursor) {
            this.baseCursor = baseCursor;
            return this;
        }
    }

    public static final class SelectedTimeFrameCursor
    implements TimeFrameRecordCursor {
        private final IntList columnCrossIndex;
        private final SelectedRecord recordA;
        private final SelectedRecord recordB;
        private TimeFrameRecordCursor baseCursor;

        public SelectedTimeFrameCursor(IntList columnCrossIndex, boolean supportsRandomAccess) {
            this.columnCrossIndex = columnCrossIndex;
            this.recordA = new SelectedRecord(columnCrossIndex);
            this.recordB = supportsRandomAccess ? new SelectedRecord(columnCrossIndex) : null;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB != null) {
                return this.recordB;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public StaticSymbolTable getSymbolTable(int columnIndex) {
            return this.baseCursor.getSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public TimeFrame getTimeFrame() {
            return this.baseCursor.getTimeFrame();
        }

        @Override
        public void jumpTo(int frameIndex) {
            this.baseCursor.jumpTo(frameIndex);
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return this.baseCursor.newSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public boolean next() {
            return this.baseCursor.next();
        }

        public SelectedTimeFrameCursor of(TimeFrameRecordCursor baseCursor) {
            this.baseCursor = baseCursor;
            this.recordA.of(baseCursor.getRecord());
            if (this.recordB != null) {
                this.recordB.of(baseCursor.getRecordB());
            }
            return this;
        }

        @Override
        public long open() throws DataUnavailableException {
            return this.baseCursor.open();
        }

        @Override
        public boolean prev() {
            return this.baseCursor.prev();
        }

        @Override
        public void recordAt(Record record, long rowId) {
            record = ((SelectedRecord)record).getBaseRecord();
            this.baseCursor.recordAt(record, rowId);
        }

        @Override
        public void recordAtRowIndex(Record record, long rowIndex) {
            record = ((SelectedRecord)record).getBaseRecord();
            this.baseCursor.recordAtRowIndex(record, rowIndex);
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
        }
    }

    private static class SelectedPageFrame
    implements PageFrame {
        private final IntList columnCrossIndex;
        private PageFrame baseFrame;

        private SelectedPageFrame(IntList columnCrossIndex) {
            this.columnCrossIndex = columnCrossIndex;
        }

        @Override
        public long getAuxPageAddress(int columnIndex) {
            return this.baseFrame.getAuxPageAddress(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getAuxPageSize(int columnIndex) {
            return this.baseFrame.getAuxPageSize(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return this.baseFrame.getBitmapIndexReader(this.columnCrossIndex.getQuick(columnIndex), direction);
        }

        @Override
        public int getColumnCount() {
            return this.columnCrossIndex.size();
        }

        @Override
        public byte getFormat() {
            return this.baseFrame.getFormat();
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return this.baseFrame.getPageAddress(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getPageSize(int columnIndex) {
            return this.baseFrame.getPageSize(this.columnCrossIndex.getQuick(columnIndex));
        }

        @Override
        public long getParquetAddr() {
            return this.baseFrame.getParquetAddr();
        }

        @Override
        public long getParquetFileSize() {
            long fileSize = this.baseFrame.getParquetFileSize();
            assert (fileSize > 0L || this.baseFrame.getFormat() != 1);
            return fileSize;
        }

        @Override
        public int getParquetRowGroup() {
            return this.baseFrame.getParquetRowGroup();
        }

        @Override
        public int getParquetRowGroupHi() {
            return this.baseFrame.getParquetRowGroupHi();
        }

        @Override
        public int getParquetRowGroupLo() {
            return this.baseFrame.getParquetRowGroupLo();
        }

        @Override
        public long getPartitionHi() {
            return this.baseFrame.getPartitionHi();
        }

        @Override
        public int getPartitionIndex() {
            return this.baseFrame.getPartitionIndex();
        }

        @Override
        public long getPartitionLo() {
            return this.baseFrame.getPartitionLo();
        }

        public SelectedPageFrame of(PageFrame basePageFrame) {
            this.baseFrame = basePageFrame;
            return this;
        }
    }
}

