/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.str.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableStorageRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int DISK_SIZE = 5;
    private static final RecordMetadata METADATA;
    private static final int PARTITION_BY = 2;
    private static final int PARTITION_COUNT = 3;
    private static final int ROW_COUNT = 4;
    private static final int TABLE_NAME = 0;
    private static final int WAL_ENABLED = 1;
    private final CairoConfiguration configuration;
    private final TableStorageRecordCursor cursor = new TableStorageRecordCursor();
    private final CairoEngine engine;
    private final TxReader txReader;

    public TableStorageRecordCursorFactory(CairoEngine engine) {
        super(METADATA);
        this.configuration = engine.getConfiguration();
        this.engine = engine;
        this.txReader = new TxReader(this.configuration.getFilesFacade());
    }

    @Override
    public void _close() {
        Misc.free(this.cursor);
        Misc.free(this.txReader);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.initialize();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("table_storage()");
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("tableName", 11));
        metadata.add(new TableColumnMetadata("walEnabled", 1));
        metadata.add(new TableColumnMetadata("partitionBy", 11));
        metadata.add(new TableColumnMetadata("partitionCount", 6));
        metadata.add(new TableColumnMetadata("rowCount", 6));
        metadata.add(new TableColumnMetadata("diskSize", 6));
        METADATA = metadata;
    }

    private class TableStorageRecordCursor
    implements NoRandomAccessRecordCursor {
        private final TableStorageRecord record = new TableStorageRecord();
        private final ObjHashSet<TableToken> tableBucket = new ObjHashSet();
        private int tableIndex = -1;

        private TableStorageRecordCursor() {
        }

        @Override
        public void close() {
            this.tableBucket.clear();
            TableStorageRecordCursorFactory.this.txReader.clear();
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            ++this.tableIndex;
            int n = this.tableBucket.size();
            if (this.tableIndex >= n) {
                return false;
            }
            do {
                TableToken token;
                if (!(token = this.tableBucket.get(this.tableIndex)).isSystem()) {
                    this.record.getTableStats(token);
                    return true;
                }
                ++this.tableIndex;
            } while (this.tableIndex < n);
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return this.tableBucket.size();
        }

        @Override
        public void toTop() {
            this.tableIndex = -1;
        }

        private TableStorageRecordCursor initialize() {
            TableStorageRecordCursorFactory.this.engine.getTableTokens(this.tableBucket, false);
            this.toTop();
            return this;
        }

        private class TableStorageRecord
        implements Record {
            private long diskSize;
            private int partitionBy;
            private long partitionCount;
            private long rowCount;
            private CharSequence tableName;
            private boolean walEnabled;

            private TableStorageRecord() {
            }

            @Override
            public boolean getBool(int col) {
                if (col == 1) {
                    return this.walEnabled;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public long getLong(int col) {
                switch (col) {
                    case 3: {
                        return this.partitionCount;
                    }
                    case 4: {
                        return this.rowCount;
                    }
                    case 5: {
                        return this.diskSize;
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public CharSequence getStrA(int col) {
                switch (col) {
                    case 0: {
                        return this.tableName;
                    }
                    case 2: {
                        return PartitionBy.toString(this.partitionBy);
                    }
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @Nullable
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return TableUtils.lengthOf(this.getStrA(col));
            }

            private void getTableStats(@NotNull TableToken token) {
                this.walEnabled = token.isWal();
                this.tableName = token.getTableName();
                try (TableMetadata tm = TableStorageRecordCursorFactory.this.engine.getTableMetadata(token);){
                    this.partitionBy = tm.getPartitionBy();
                }
                Path path = Path.getThreadLocal(TableStorageRecordCursorFactory.this.configuration.getDbRoot()).concat(token.getDirName());
                this.diskSize = Files.getDirSize(path);
                TableUtils.setTxReaderPath(TableStorageRecordCursorFactory.this.txReader, path, this.partitionBy);
                this.rowCount = TableStorageRecordCursorFactory.this.txReader.unsafeLoadRowCount();
                this.partitionCount = TableStorageRecordCursorFactory.this.txReader.getPartitionCount();
            }
        }
    }
}

