/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.ParanoiaState;
import io.questdb.log.Log;
import io.questdb.log.LogError;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecord;
import io.questdb.log.LogRecordUtf8Sink;
import io.questdb.log.NullLogRecord;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.network.Net;
import io.questdb.std.Numbers;
import io.questdb.std.ObjHashSet;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractLogRecord
implements LogRecord,
Log {
    private static final ThreadLocal<ObjHashSet<Throwable>> tlSet = ThreadLocal.withInitial(ObjHashSet::new);
    protected final RingQueue<LogRecordUtf8Sink> advisoryRing;
    protected final Sequence advisorySeq;
    protected final RingQueue<LogRecordUtf8Sink> criticalRing;
    protected final Sequence criticalSeq;
    protected final RingQueue<LogRecordUtf8Sink> debugRing;
    protected final Sequence debugSeq;
    protected final RingQueue<LogRecordUtf8Sink> errorRing;
    protected final Sequence errorSeq;
    protected final RingQueue<LogRecordUtf8Sink> infoRing;
    protected final Sequence infoSeq;
    protected final ThreadLocal<CursorHolder> tl = ThreadLocal.withInitial(CursorHolder::new);
    private final MicrosecondClock clock;
    private final CharSequence name;

    AbstractLogRecord(MicrosecondClock clock, CharSequence name, RingQueue<LogRecordUtf8Sink> debugRing, Sequence debugSeq, RingQueue<LogRecordUtf8Sink> infoRing, Sequence infoSeq, RingQueue<LogRecordUtf8Sink> errorRing, Sequence errorSeq, RingQueue<LogRecordUtf8Sink> criticalRing, Sequence criticalSeq, RingQueue<LogRecordUtf8Sink> advisoryRing, Sequence advisorySeq) {
        this.name = name;
        this.clock = clock;
        this.debugRing = debugRing;
        this.debugSeq = debugSeq;
        this.infoRing = infoRing;
        this.infoSeq = infoSeq;
        this.errorRing = errorRing;
        this.errorSeq = errorSeq;
        this.criticalRing = criticalRing;
        this.criticalSeq = criticalSeq;
        this.advisoryRing = advisoryRing;
        this.advisorySeq = advisorySeq;
    }

    @Override
    public LogRecord $(int x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(double x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(@Nullable Utf8Sequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(@Nullable DirectUtf8Sequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(@Nullable File x) {
        this.sink().put(x == null ? "null" : x.getAbsolutePath());
        return this;
    }

    @Override
    public LogRecord $(@Nullable CharSequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            this.sink().putAscii(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(@Nullable Object x) {
        if (x == null) {
            this.sink().putAscii("null");
        } else {
            try {
                this.sink().put(x.toString());
            }
            catch (Throwable t) {
                this.$();
                throw t;
            }
        }
        return this;
    }

    @Override
    public LogRecord $(@Nullable Sinkable x) {
        if (x == null) {
            this.sink().putAscii("null");
        } else {
            try {
                x.toSink(this.sink());
            }
            catch (Throwable t) {
                this.$();
                throw t;
            }
        }
        return this;
    }

    @Override
    public LogRecord $(long l) {
        this.sink().put(l);
        return this;
    }

    @Override
    public LogRecord $(boolean x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord $(@Nullable Throwable e) {
        if (e == null) {
            return this;
        }
        LogRecordUtf8Sink sink = this.sink();
        ObjHashSet<Throwable> dejaVu = tlSet.get();
        dejaVu.add(e);
        sink.putEOL();
        AbstractLogRecord.put0(sink, e);
        sink.putEOL();
        StackTraceElement[] trace = e.getStackTrace();
        int n = trace.length;
        for (int i = 0; i < n; ++i) {
            AbstractLogRecord.put(sink, trace[i]);
        }
        Throwable[] suppressed = e.getSuppressed();
        int n2 = suppressed.length;
        for (int i = 0; i < n2; ++i) {
            AbstractLogRecord.put(sink, suppressed[i], trace, "Suppressed: ", "\t", dejaVu);
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            AbstractLogRecord.put(sink, ourCause, trace, "Caused by: ", "", dejaVu);
        }
        return this;
    }

    @Override
    public void $() {
        CursorHolder h = this.tl.get();
        LogRecordUtf8Sink sink = h.ring.get(h.cursor);
        sink.putEOL();
        try {
            if (ParanoiaState.LOG_PARANOIA_MODE != 0) {
                AbstractLogRecord.validateUtf8(sink);
            }
        }
        finally {
            h.isLogRecordInProgress = false;
            h.seq.done(h.cursor);
        }
    }

    @Override
    public LogRecord $256(long a, long b, long c, long d) {
        Numbers.appendLong256(a, b, c, d, this.sink());
        return this;
    }

    @Override
    public LogRecord $hex(long value) {
        Numbers.appendHex(this.sink(), value, false);
        return this;
    }

    @Override
    public LogRecord $hexPadded(long value) {
        Numbers.appendHex(this.sink(), value, true);
        return this;
    }

    @Override
    public LogRecord $ip(long ip) {
        Net.appendIP4(this.sink(), ip);
        return this;
    }

    @Override
    public LogRecord $safe(@Nullable DirectUtf8Sequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            Utf8s.putSafe(sequence.lo(), sequence.hi(), this.sink());
        }
        return this;
    }

    @Override
    public LogRecord $safe(@NotNull CharSequence sequence, int lo, int hi) {
        this.sink().put(sequence, lo, hi);
        return this;
    }

    @Override
    public LogRecord $safe(@Nullable Utf8Sequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $safe(long lo, long hi) {
        Utf8s.putSafe(lo, hi, this.sink());
        return this;
    }

    @Override
    public LogRecord $safe(@Nullable CharSequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $size(long memoryBytes) {
        this.sink().putSize(memoryBytes);
        return this;
    }

    @Override
    public LogRecord $substr(int from, @Nullable DirectUtf8Sequence sequence) {
        if (sequence == null) {
            this.sink().putAscii("null");
        } else if (from > -1 && sequence.size() > from) {
            this.sink().putNonAscii(sequence.lo() + (long)from, sequence.hi());
        } else {
            ((Utf8Sink)((Utf8Sink)this.sink().put("WTF? substr? [from:").put(from)).put(", sequence=").put(sequence).put(", size=").put(sequence.size())).put(']');
        }
        return this;
    }

    @Override
    public LogRecord $ts(long x) {
        this.sink().putISODate(x);
        return this;
    }

    @Override
    public LogRecord $uuid(long lo, long hi) {
        Numbers.appendUuid(lo, hi, this);
        return this;
    }

    @Override
    public LogRecord advisory() {
        return this.addTimestamp(this.xAdvisoryW(), LogLevel.ADVISORY_HEADER);
    }

    @Override
    public LogRecord advisoryW() {
        return this.addTimestamp(this.xAdvisoryW(), LogLevel.ADVISORY_HEADER);
    }

    @Override
    public LogRecord critical() {
        return this.addTimestamp(this.xCriticalW(), LogLevel.CRITICAL_HEADER);
    }

    @Override
    public LogRecord debug() {
        return this.addTimestamp(this.xdebug(), LogLevel.DEBUG_HEADER);
    }

    @Override
    public LogRecord debugW() {
        return this.addTimestamp(this.xDebugW(), LogLevel.DEBUG_HEADER);
    }

    @Override
    public LogRecord error() {
        return this.addTimestamp(this.xerror(), LogLevel.ERROR_HEADER);
    }

    @Override
    public LogRecord errorW() {
        return this.addTimestamp(this.xErrorW(), LogLevel.ERROR_HEADER);
    }

    public Sequence getCriticalSequence() {
        return this.criticalSeq;
    }

    @Override
    public LogRecord info() {
        return this.addTimestamp(this.xinfo(), LogLevel.INFO_HEADER);
    }

    @Override
    public LogRecord infoW() {
        return this.addTimestamp(this.xInfoW(), LogLevel.INFO_HEADER);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public LogRecord microTime(long x) {
        TimestampFormatUtils.appendDateTimeUSec(this.sink(), x);
        return this;
    }

    @Override
    public LogRecord put(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord put(byte b) {
        this.sink().put(b);
        return this;
    }

    @Override
    public Utf8Sink put(@Nullable Utf8Sequence us) {
        this.sink().put(us);
        return this;
    }

    @Override
    public Utf8Sink putNonAscii(long lo, long hi) {
        this.sink().putNonAscii(lo, hi);
        return this;
    }

    @Override
    public LogRecord ts() {
        long us = this.clock.getTicks();
        if (LogLevel.TIMESTAMP_TIMEZONE_RULES != null) {
            LogLevel.TIMESTAMP_FORMAT.format(LogLevel.TIMESTAMP_TIMEZONE_RULES.getOffset(us) + us, LogLevel.TIMESTAMP_TIMEZONE_LOCALE, LogLevel.TIMESTAMP_TIMEZONE, this.sink());
        } else {
            this.sink().putISODate(us);
        }
        return this;
    }

    @Override
    public LogRecord xDebugW() {
        return this.nextWaiting(this.debugSeq, this.debugRing, LogLevel.DEBUG);
    }

    public LogRecord xErrorW() {
        return this.nextWaiting(this.errorSeq, this.errorRing, LogLevel.ERROR);
    }

    @Override
    public LogRecord xInfoW() {
        return this.nextWaiting(this.infoSeq, this.infoRing, LogLevel.INFO);
    }

    private static void put(Utf8Sink sink, Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(throwable)) {
            sink.putAscii("\t[CIRCULAR REFERENCE:");
            AbstractLogRecord.put0(sink, throwable);
            sink.putAscii(']');
        } else {
            dejaVu.add(throwable);
            StackTraceElement[] trace = throwable.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            sink.put(prefix).put(caption);
            AbstractLogRecord.put0(sink, throwable);
            sink.putEOL();
            for (int i = 0; i <= m; ++i) {
                sink.put(prefix);
                AbstractLogRecord.put(sink, trace[i]);
            }
            if (framesInCommon != 0) {
                ((Utf8Sink)sink.put(prefix).putAscii("\t...").put(framesInCommon)).putAscii(" more");
            }
            Throwable[] suppressed = throwable.getSuppressed();
            int k = suppressed.length;
            for (int i = 0; i < k; ++i) {
                AbstractLogRecord.put(sink, suppressed[i], trace, "Suppressed: ", prefix + "\t", dejaVu);
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                AbstractLogRecord.put(sink, cause, trace, "Caused by: ", prefix, dejaVu);
            }
        }
    }

    private static void put(Utf8Sink sink, StackTraceElement e) {
        sink.putAscii("\tat ");
        sink.putAscii(e.getClassName());
        sink.putAscii('.');
        sink.putAscii(e.getMethodName());
        if (e.isNativeMethod()) {
            sink.putAscii("(Native Method)");
        } else if (e.getFileName() != null && e.getLineNumber() > -1) {
            ((Utf8Sink)sink.putAscii('(').put(e.getFileName()).putAscii(':').put(e.getLineNumber())).putAscii(')');
        } else if (e.getFileName() != null) {
            sink.putAscii('(').put(e.getFileName()).putAscii(')');
        } else {
            sink.putAscii("(Unknown Source)");
        }
        sink.put("\r\n");
    }

    private static void put0(Utf8Sink sink, Throwable e) {
        sink.putAscii(e.getClass().getName());
        if (e.getMessage() != null) {
            sink.putAscii(": ").put(e.getMessage());
        }
    }

    private static void validateUtf8(LogRecordUtf8Sink sink) {
        if (Utf8s.validateUtf8(sink) < 0) {
            LogError e = new LogError("Invalid UTF-8, partial message: \n" + Utf8s.stringFromUtf8BytesSafe(sink) + "\nEND partial message");
            sink.clear();
            e.printStackTrace(System.out);
            throw e;
        }
    }

    @Nullable
    private LogError detectAbandonedLogRecord(CursorHolder h) throws LogError {
        LogError logError = h.abandonedLogRecordError;
        if (!h.isLogRecordInProgress) {
            h.isLogRecordInProgress = true;
            logError.fillInStackTrace();
            return null;
        }
        this.$(" #$#$ ABANDONED LOG RECORD #$#$").$();
        return logError;
    }

    protected LogRecord addTimestamp(LogRecord rec, String level) {
        return rec.ts().$(level).$(this.name);
    }

    protected LogRecord nextWaiting(Sequence seq, RingQueue<LogRecordUtf8Sink> ring, int level) {
        if (seq == null) {
            return NullLogRecord.INSTANCE;
        }
        return this.prepareLogRecord(seq, ring, level, seq.nextBully());
    }

    @NotNull
    protected LogRecord prepareLogRecord(Sequence seq, RingQueue<LogRecordUtf8Sink> ring, int level, long cursor) {
        CursorHolder h = this.tl.get();
        LogError logError = this.detectAbandonedLogRecord(h);
        h.cursor = cursor;
        h.seq = seq;
        h.ring = ring;
        LogRecordUtf8Sink sink = ring.get(cursor);
        sink.setLevel(level);
        sink.clear();
        if (logError == null) {
            return this;
        }
        logError.printStackTrace(System.out);
        if (ParanoiaState.LOG_PARANOIA_MODE != 0) {
            seq.done(cursor);
            throw logError;
        }
        return this;
    }

    protected LogRecordUtf8Sink sink() {
        CursorHolder h = this.tl.get();
        return h.ring.get(h.cursor);
    }

    protected LogRecord xAdvisoryW() {
        return this.nextWaiting(this.advisorySeq, this.advisoryRing, LogLevel.ADVISORY);
    }

    protected LogRecord xCriticalW() {
        return this.nextWaiting(this.criticalSeq, this.criticalRing, LogLevel.CRITICAL);
    }

    protected static class CursorHolder {
        final LogError abandonedLogRecordError = CursorHolder.createAbandonedLogError();
        protected long cursor;
        protected RingQueue<LogRecordUtf8Sink> ring;
        protected Sequence seq;
        boolean isLogRecordInProgress;

        protected CursorHolder() {
        }

        @NotNull
        private static LogError createAbandonedLogError() {
            if (ParanoiaState.LOG_PARANOIA_MODE == 2) {
                return new LogError("Abandoned log record");
            }
            return new LogError("Abandoned log record detected. Use LOG_PARANOIA_MODE_AGGRESSIVE to diagnose.", false);
        }
    }
}

