/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.SelectAccessor;
import io.questdb.std.Files;
import io.questdb.std.IntLongHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.QuietCloseable;
import io.questdb.std.Unsafe;

public class FDSet
implements QuietCloseable,
Mutable {
    private final IntLongHashMap longFds = new IntLongHashMap();
    private long _wptr;
    private long address;
    private long lim;
    private int size;

    public FDSet(int size) {
        int l = SelectAccessor.ARRAY_OFFSET + 8 * size;
        this.address = Unsafe.malloc(l, 36);
        this.size = size;
        this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
        this.lim = this.address + (long)l;
    }

    public void add(long fd) {
        if (this._wptr == this.lim) {
            this.resize();
        }
        long p = this._wptr;
        int osFd = Files.toOsFd(fd);
        Unsafe.getUnsafe().putLong(p, osFd);
        this._wptr = p + 8L;
        this.longFds.put(osFd, fd);
    }

    public long address() {
        return this.address;
    }

    @Override
    public void clear() {
        this._wptr = this.address + (long)SelectAccessor.ARRAY_OFFSET;
        this.longFds.clear();
    }

    @Override
    public void close() {
        if (this.address != 0L) {
            this.address = Unsafe.free(this.address, this.lim - this.address, 36);
            this.longFds.clear();
        }
    }

    public long get(int index) {
        int fd = (int)Unsafe.getUnsafe().getLong(this.address + (long)SelectAccessor.ARRAY_OFFSET + (long)index * 8L);
        return this.longFds.get(fd);
    }

    public int getCount() {
        return Unsafe.getUnsafe().getInt(this.address + (long)SelectAccessor.COUNT_OFFSET);
    }

    public void setCount(int count) {
        Unsafe.getUnsafe().putInt(this.address + (long)SelectAccessor.COUNT_OFFSET, count);
    }

    private void resize() {
        int l = SelectAccessor.ARRAY_OFFSET + 8 * this.size * 2;
        long offset = this._wptr - this.address;
        this.address = Unsafe.realloc(this.address, this.lim - this.address, l, 36);
        this.lim = this.address + (long)l;
        this.size *= 2;
        this._wptr = this.address + offset;
    }
}

