/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.std.Chars;
import io.questdb.std.FdCache;
import io.questdb.std.FindVisitor;
import io.questdb.std.MmapCache;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.MutableUtf8Sink;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Files {
    public static final long DEFAULT_FILE_LIMIT = 65536L;
    public static final long DEFAULT_MAP_COUNT_LIMIT = 65536L;
    public static final int DT_DIR = 4;
    public static final int DT_FILE = 8;
    public static final int DT_LNK = 10;
    public static final int DT_UNKNOWN = 0;
    public static final int FILES_RENAME_ERR_EXDEV = 1;
    public static final int FILES_RENAME_ERR_OTHER = 2;
    public static final int FILES_RENAME_OK = 0;
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final int NFS_MAGIC = 26985;
    public static final long PAGE_SIZE;
    public static final int POSIX_FADV_RANDOM;
    public static final int POSIX_FADV_SEQUENTIAL;
    public static final int POSIX_MADV_RANDOM;
    public static final int POSIX_MADV_SEQUENTIAL;
    public static final char SEPARATOR;
    public static final Charset UTF_8;
    public static final int WINDOWS_ERROR_FILE_EXISTS = 80;
    private static final int VIRTIO_FS_MAGIC = 1785031267;
    private static final FdCache fdCache;
    private static final MmapCache mmapCache;
    public static boolean FS_CACHE_ENABLED;
    public static boolean VIRTIO_FS_DETECTED;

    private Files() {
    }

    public static boolean allocate(long fd, long size) {
        return Files.allocate(Files.toOsFd(fd), size);
    }

    public static long append(long fd, long address, long len) {
        return Files.append(Files.toOsFd(fd), address, len);
    }

    public static long ceilPageSize(long size) {
        return (size + PAGE_SIZE - 1L) / PAGE_SIZE * PAGE_SIZE;
    }

    public static int close(long fd) {
        if (fd > 0L && Files.toOsFd(fd) > 2) {
            return fdCache.close(fd);
        }
        return -1;
    }

    public static int copy(LPSZ from, LPSZ to) {
        return Files.copy(from.ptr(), to.ptr());
    }

    public static long copyData(long srcFd, long destFd, long offsetSrc, long length) {
        return Files.copyData(Files.toOsFd(srcFd), Files.toOsFd(destFd), offsetSrc, length);
    }

    public static long copyDataToOffset(long srcFd, long destFd, long offsetSrc, long offsetDest, long length) {
        return Files.copyDataToOffset(Files.toOsFd(srcFd), Files.toOsFd(destFd), offsetSrc, offsetDest, length);
    }

    public static long createUniqueFd(int fd) {
        if (fd != -1) {
            return fdCache.createUniqueFdNonCached(fd);
        }
        return fd;
    }

    public static int detach(long fd) {
        int osFd = Files.toOsFd(fd);
        if (osFd > 1) {
            fdCache.detach(fd);
            return osFd;
        }
        return -1;
    }

    public static boolean errnoFileCannotRead(int errno) {
        return Files.errnoFileDoesNotExist(errno) || Os.type == 3 && errno == 5;
    }

    public static boolean errnoFileDoesNotExist(int errno) {
        return errno == 2 || Os.type == 3 && errno == 3;
    }

    public static boolean exists(long fd) {
        return Files.exists(Files.toOsFd(fd));
    }

    public static boolean exists(LPSZ lpsz) {
        return lpsz != null && Files.exists0(lpsz.ptr());
    }

    public static void fadvise(long fd, long offset, long len, int advise) {
        if (Os.isLinux()) {
            Files.fadvise0(Files.toOsFd(fd), offset, len, advise);
        }
    }

    public static native void findClose(long var0);

    public static long findFirst(LPSZ lpsz) {
        return Files.findFirst(lpsz.ptr());
    }

    public static native long findName(long var0);

    public static native int findNext(long var0);

    public static native int findType(long var0);

    public static long floorPageSize(long size) {
        return size - size % PAGE_SIZE;
    }

    public static int fsync(long fd) {
        return Files.fsync(Files.toOsFd(fd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDirSize(Path path) {
        long pFind = Files.findFirst(path.$().ptr());
        if (pFind > 0L) {
            int len = path.size();
            try {
                long totalSize = 0L;
                do {
                    long nameUtf8Ptr = Files.findName(pFind);
                    path.trimTo(len).concat(nameUtf8Ptr).$();
                    if (Files.findType(pFind) == 8) {
                        totalSize += Files.length(path.$());
                        continue;
                    }
                    if (!Files.notDots(nameUtf8Ptr)) continue;
                    totalSize += Files.getDirSize(path);
                } while (Files.findNext(pFind) > 0);
                long l = totalSize;
                return l;
            }
            finally {
                Files.findClose(pFind);
                path.trimTo(len);
            }
        }
        return 0L;
    }

    public static long getDiskFreeSpace(LPSZ path) {
        if (path != null) {
            return Files.getDiskSize(path.ptr());
        }
        return 0L;
    }

    public static long getFdReuseCount() {
        return fdCache.getReuseCount();
    }

    public static native long getFileLimit();

    public static int getFileSystemStatus(LPSZ lpszName) {
        int status = Files.getFileSystemStatus(lpszName.ptr());
        if (status == 1785031267) {
            VIRTIO_FS_DETECTED = true;
        }
        return status;
    }

    public static long getLastModified(LPSZ lpsz) {
        return Files.getLastModified(lpsz.ptr());
    }

    public static native long getMapCountLimit();

    public static long getMmapReuseCount() {
        return mmapCache.getReuseCount();
    }

    public static long getOpenCachedFileCount() {
        return fdCache.getOpenCachedFileCount();
    }

    public static String getOpenFdDebugInfo() {
        return fdCache.getOpenFdDebugInfo();
    }

    public static long getOpenFileCount() {
        return fdCache.getOpenOsFileCount();
    }

    @NotNull
    public static String getResourcePath(@Nullable URL url) {
        assert (url != null);
        String file = url.getFile();
        assert (file != null);
        assert (!file.isEmpty());
        return file;
    }

    public static synchronized long getStdOutFdInternal() {
        int stdoutFd = Files.getStdOutFd();
        return fdCache.createUniqueFdNonCachedStdOut(stdoutFd);
    }

    public static native int hardLink(long var0, long var2);

    public static int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src.ptr(), hardLink.ptr());
    }

    public static boolean isDirOrSoftLinkDir(LPSZ path) {
        return Files.isDir(path.ptr());
    }

    public static boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type) {
        return 0 != Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, null);
    }

    public static boolean isDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @NotNull MutableUtf8Sink nameSink) {
        return 0 != Files.typeDirOrSoftLinkDirNoDots(path, rootLen, pUtf8NameZ, type, nameSink);
    }

    public static boolean isDots(CharSequence name) {
        return Chars.equals(name, '.') || Chars.equals(name, (CharSequence)"..");
    }

    public static native boolean isSoftLink(long var0);

    public static boolean isSoftLink(LPSZ path) {
        return Files.isSoftLink(path.ptr());
    }

    public static long length(LPSZ lpsz) {
        return Files.length0(lpsz.ptr());
    }

    public static long length(long fd) {
        return Files.length(Files.toOsFd(fd));
    }

    public static int lock(long fd) {
        return Files.lock(Files.toOsFd(fd));
    }

    public static void madvise(long address, long len, int advise) {
        if (Os.isLinux() && mmapCache.isSingleUse(address)) {
            Files.madvise0(address, len, advise);
        }
    }

    public static native void madvise0(long var0, long var2, int var4);

    public static int mkdir(LPSZ path, int mode) {
        return Files.mkdir(path.ptr(), mode);
    }

    public static int mkdirs(Path path, int mode) {
        int n = path.size();
        for (int i = 0; i < n; ++i) {
            int r;
            byte b = path.byteAt(i);
            if (b != SEPARATOR || i == 0 && Os.isPosix() || i == 2 && Os.isWindows() && path.byteAt(1) == 58) continue;
            path.$at(i);
            LPSZ lpsz = path.$();
            if (path.size() > 0 && !Files.exists(lpsz) && (r = Files.mkdir(lpsz, mode)) != 0) {
                path.put(i, (byte)SEPARATOR);
                return r;
            }
            path.put(i, (byte)SEPARATOR);
        }
        return 0;
    }

    public static long mmap(long fd, long len, long offset, int flags, int memoryTag) {
        int osFd = fdCache.toOsFd(fd, (flags & 2) != 0);
        long mmapCacheFd = fdCache.toMmapCacheFd(fd);
        return mmapCache.cacheMmap(osFd, mmapCacheFd, len, offset, flags, memoryTag);
    }

    public static long mremap(long fd, long address, long previousSize, long newSize, long offset, int flags, int memoryTag) {
        if (newSize < 1L) {
            throw CairoException.critical(0).put("could not remap file, invalid newSize [previousSize=").put(previousSize).put(", newSize=").put(newSize).put(", offset=").put(offset).put(", fd=").put(fd).put(", memoryTag=").put(memoryTag).put(']');
        }
        int osFd = fdCache.toOsFd(fd, (flags & 2) != 0);
        long mmapCacheFd = fdCache.toMmapCacheFd(fd);
        return mmapCache.mremap(osFd, mmapCacheFd, address, previousSize, newSize, offset, flags, memoryTag);
    }

    public static native int msync(long var0, long var2, boolean var4);

    public static void munmap(long address, long len, int memoryTag) {
        mmapCache.unmap(address, len, memoryTag);
    }

    public static native long noop();

    public static boolean notDots(Utf8Sequence value) {
        int size = value.size();
        if (size > 2) {
            return true;
        }
        if (value.byteAt(0) != 46) {
            return true;
        }
        return size == 2 && value.byteAt(1) != 46;
    }

    public static boolean notDots(long pUtf8NameZ) {
        byte b0 = Unsafe.getUnsafe().getByte(pUtf8NameZ);
        if (b0 != 46) {
            return true;
        }
        byte b1 = Unsafe.getUnsafe().getByte(pUtf8NameZ + 1L);
        return b1 != 0 && (b1 != 46 || Unsafe.getUnsafe().getByte(pUtf8NameZ + 2L) != 0);
    }

    public static long openAppend(LPSZ lpsz) {
        return fdCache.createUniqueFdNonCached(Files.openAppend(lpsz.ptr()));
    }

    public static long openCleanRW(LPSZ lpsz, long size) {
        return fdCache.createUniqueFdNonCached(Files.openCleanRW(lpsz.ptr(), size));
    }

    public static native int openCleanRW(long var0, long var2);

    public static long openRO(LPSZ lpsz) {
        if (FS_CACHE_ENABLED) {
            return fdCache.openROCached(lpsz);
        }
        return fdCache.createUniqueFdNonCached(Files.openRO(lpsz.ptr()));
    }

    public static long openRONoCache(LPSZ path) {
        return fdCache.createUniqueFdNonCached(Files.openRO(path.ptr()));
    }

    public static long openRW(LPSZ lpsz) {
        return fdCache.createUniqueFdNonCached(Files.openRW(lpsz.ptr()));
    }

    public static long openRW(LPSZ lpsz, int opts) {
        return fdCache.createUniqueFdNonCached(Files.openRWOpts(lpsz.ptr(), opts));
    }

    public static long read(long fd, long address, long len, long offset) {
        return Files.read(fdCache.toOsFd(fd), address, len, offset);
    }

    public static long readIntAsUnsignedLong(long fd, long offset) {
        return Files.readIntAsUnsignedLong(Files.toOsFd(fd), offset);
    }

    public static boolean readLink(Path softLink, Path readTo) {
        int len = readTo.size();
        int bufSize = 1024;
        readTo.zeroPad(1024);
        int res = Files.readLink0(softLink.$().ptr(), readTo.$().ptr() + (long)len, 1024);
        if (res > 0 && res < 1024) {
            int prefixLen;
            readTo.trimTo(len + res);
            if (readTo.byteAt(0) != 47 && (prefixLen = Utf8s.lastIndexOfAscii(softLink, '/')) > 0) {
                readTo.prefix(softLink, prefixLen + 1).$();
            }
            return true;
        }
        return false;
    }

    public static byte readNonNegativeByte(long fd, long offset) {
        return Files.readNonNegativeByte(Files.toOsFd(fd), offset);
    }

    public static int readNonNegativeInt(long fd, long offset) {
        return Files.readNonNegativeInt(Files.toOsFd(fd), offset);
    }

    public static long readNonNegativeLong(long fd, long offset) {
        return Files.readNonNegativeLong(Files.toOsFd(fd), offset);
    }

    public static short readNonNegativeShort(long fd, long offset) {
        return Files.readNonNegativeShort(Files.toOsFd(fd), offset);
    }

    public static boolean remove(LPSZ lpsz) {
        return fdCache.remove(lpsz);
    }

    public static int rename(LPSZ oldName, LPSZ newName) {
        return fdCache.rename(oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmdir(Path path, boolean haltOnFail) {
        path.$();
        long pFind = Files.findFirst(path.ptr());
        if (pFind > 0L) {
            int len = path.size();
            try {
                do {
                    boolean res;
                    long nameUtf8Ptr = Files.findName(pFind);
                    path.trimTo(len).concat(nameUtf8Ptr).$();
                    int type = Files.findType(pFind);
                    if (type == 8) {
                        if (Files.remove(path.ptr()) || !haltOnFail) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (!Files.notDots(nameUtf8Ptr)) continue;
                    boolean bl = type == 10 ? Files.unlink(path.ptr()) == 0 : (res = Files.rmdir(path, haltOnFail));
                    if (res || !haltOnFail) continue;
                    boolean bl2 = false;
                    return bl2;
                } while (Files.findNext(pFind) > 0);
            }
            finally {
                Files.findClose(pFind);
                path.trimTo(len).$();
            }
            if (Files.isSoftLink(path.ptr())) {
                return Files.unlink(path.ptr()) == 0;
            }
            return Files.rmdir(path.ptr());
        }
        return false;
    }

    public static boolean setLastModified(LPSZ lpsz, long millis) {
        return Files.setLastModified(lpsz.ptr(), millis);
    }

    public static native int softLink(long var0, long var2);

    public static int softLink(LPSZ src, LPSZ softLink) {
        return Files.softLink(src.ptr(), softLink.ptr());
    }

    public static native int sync();

    public static int toOsFd(long fd) {
        return fdCache.toOsFd(fd);
    }

    public static boolean touch(LPSZ lpsz) {
        boolean result;
        long fd = Files.openRW(lpsz);
        boolean bl = result = fd > 0L;
        if (result) {
            Files.close(fd);
        }
        return result;
    }

    public static boolean truncate(long fd, long size) {
        return Files.truncate(Files.toOsFd(fd), size);
    }

    public static int typeDirOrSoftLinkDirNoDots(Path path, int rootLen, long pUtf8NameZ, int type, @Nullable MutableUtf8Sink nameSink) {
        if (!Files.notDots(pUtf8NameZ)) {
            return 0;
        }
        if (type == 4) {
            if (nameSink != null) {
                nameSink.clear();
                Utf8s.utf8ZCopy(pUtf8NameZ, nameSink);
            }
            path.trimTo(rootLen).concat(pUtf8NameZ).$();
            return 4;
        }
        if (type == 10) {
            if (nameSink != null) {
                nameSink.clear();
                Utf8s.utf8ZCopy(pUtf8NameZ, nameSink);
            }
            path.trimTo(rootLen).concat(pUtf8NameZ).$();
            if (Files.isDir(path.ptr())) {
                return 10;
            }
        }
        return 0;
    }

    public static native int unlink(long var0);

    public static int unlink(LPSZ softLink) {
        return Files.unlink(softLink.ptr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void walk(Path path, FindVisitor func) {
        int len = path.size();
        long p = Files.findFirst(path.$());
        if (p > 0L) {
            try {
                do {
                    long name;
                    if (!Files.notDots(name = Files.findName(p))) continue;
                    int type = Files.findType(p);
                    path.trimTo(len);
                    if (type == 8) {
                        func.onFind(name, type);
                        continue;
                    }
                    Files.walk(path.concat(name), func);
                } while (Files.findNext(p) > 0);
            }
            finally {
                Files.findClose(p);
            }
        }
    }

    public static long write(long fd, long address, long len, long offset) {
        return Files.write(Files.toOsFd(fd), address, len, offset);
    }

    private static native boolean allocate(int var0, long var1);

    private static native long append(int var0, long var1, long var3);

    private static native int copy(long var0, long var2);

    private static native long copyData(int var0, int var1, long var2, long var4);

    private static native long copyDataToOffset(int var0, int var1, long var2, long var4, long var6);

    private static native boolean exists(int var0);

    private static native boolean exists0(long var0);

    private static native void fadvise0(int var0, long var1, long var3, int var5);

    private static native long findFirst(long var0);

    private static native int fsync(int var0);

    private static native long getDiskSize(long var0);

    private static native int getFileSystemStatus(long var0);

    private static native long getLastModified(long var0);

    private static native long getPageSize();

    private static native int getPosixFadvRandom();

    private static native int getPosixFadvSequential();

    private static native int getPosixMadvRandom();

    private static native int getPosixMadvSequential();

    private static native int getStdOutFd();

    private static native boolean isDir(long var0);

    private static native long length(int var0);

    private static native long length0(long var0);

    private static native int lock(int var0);

    private static native int mkdir(long var0, int var2);

    private static native int openAppend(long var0);

    private static native int openRW(long var0);

    private static native int openRWOpts(long var0, int var2);

    private static native long read(int var0, long var1, long var3, long var5);

    private static native long readIntAsUnsignedLong(int var0, long var1);

    private static native int readLink0(long var0, long var2, int var4);

    private static native byte readNonNegativeByte(int var0, long var1);

    private static native int readNonNegativeInt(int var0, long var1);

    private static native long readNonNegativeLong(int var0, long var1);

    private static native short readNonNegativeShort(int var0, long var1);

    private static native boolean rmdir(long var0);

    private static native boolean setLastModified(long var0, long var2);

    private static native boolean truncate(int var0, long var1);

    private static native long write(int var0, long var1, long var3, long var5);

    static native int close0(int var0);

    static native long mmap0(int var0, long var1, long var3, int var5, long var6);

    static native long mremap0(int var0, long var1, long var3, long var5, long var7, int var9);

    static native int munmap0(long var0, long var2);

    static native int openRO(long var0);

    static native boolean remove(long var0);

    static native int rename(long var0, long var2);

    static {
        fdCache = new FdCache();
        mmapCache = new MmapCache();
        FS_CACHE_ENABLED = true;
        VIRTIO_FS_DETECTED = false;
        Os.init();
        UTF_8 = StandardCharsets.UTF_8;
        PAGE_SIZE = Files.getPageSize();
        SEPARATOR = File.separatorChar;
        if (Os.isLinux()) {
            POSIX_FADV_RANDOM = Files.getPosixFadvRandom();
            POSIX_FADV_SEQUENTIAL = Files.getPosixFadvSequential();
            POSIX_MADV_RANDOM = Files.getPosixMadvRandom();
            POSIX_MADV_SEQUENTIAL = Files.getPosixMadvSequential();
        } else {
            POSIX_FADV_SEQUENTIAL = -1;
            POSIX_FADV_RANDOM = -1;
            POSIX_MADV_SEQUENTIAL = -1;
            POSIX_MADV_RANDOM = -1;
        }
    }
}

