/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class LowerCaseAsciiCharSequenceLongHashMap
extends AbstractLowerCaseAsciiCharSequenceHashSet {
    private static final long NO_ENTRY_VALUE = -1L;
    private final long noEntryValue;
    private long[] values;

    public LowerCaseAsciiCharSequenceLongHashMap() {
        this(8);
    }

    public LowerCaseAsciiCharSequenceLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1L);
    }

    public LowerCaseAsciiCharSequenceLongHashMap(int initialCapacity, double loadFactor, long noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.values = new long[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    public long get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public boolean put(CharSequence key, long value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, long value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, Chars.toLowerCaseAscii(key), value);
        return true;
    }

    public void putIfAbsent(CharSequence key, long value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, Chars.toLowerCaseAscii(key), value);
        }
    }

    public long valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : this.noEntryValue;
    }

    private void putAt0(int index, CharSequence key, long value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        long[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[len];
        this.values = new long[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

