/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Files;
import io.questdb.std.LongObjHashMap;
import io.questdb.std.ObjStack;
import io.questdb.std.Unsafe;

public class MmapCache {
    private static final int MAX_RECORD_POOL_CAPACITY = 16384;
    private final LongObjHashMap<MmapCacheRecord> mmapAddrCache = new LongObjHashMap();
    private final LongObjHashMap<MmapCacheRecord> mmapFileCache = new LongObjHashMap();
    private final ObjStack<MmapCacheRecord> recordPool = new ObjStack();
    private long mmapReuseCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheMmap(int fd, long fileCacheKey, long len, long offset, int flags, int memoryTag) {
        if (offset != 0L || fileCacheKey == 0L || !Files.FS_CACHE_ENABLED || flags == 2 || len == 0L) {
            return MmapCache.mmap0(fd, len, offset, flags, memoryTag);
        }
        MmapCache mmapCache = this;
        synchronized (mmapCache) {
            long address;
            int fdMapIndex = this.mmapFileCache.keyIndex(fileCacheKey);
            if (fdMapIndex < 0) {
                MmapCacheRecord record = this.mmapFileCache.valueAt(fdMapIndex);
                if (record.length >= len) {
                    ++record.count;
                    ++this.mmapReuseCount;
                    return record.address;
                }
            }
            if ((address = MmapCache.mmap0(fd, len, 0L, 1, memoryTag)) == -1L) {
                return address;
            }
            MmapCacheRecord record = this.createMmapCacheRecord(fd, fileCacheKey, len, address, memoryTag);
            this.mmapFileCache.putAt(fdMapIndex, fileCacheKey, record);
            this.mmapAddrCache.put(address, record);
            return address;
        }
    }

    public long getReuseCount() {
        return this.mmapReuseCount;
    }

    public synchronized boolean isSingleUse(long address) {
        MmapCacheRecord cacheRecord = this.mmapAddrCache.get(address);
        return cacheRecord != null && cacheRecord.count == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mremap(int fd, long fileCacheKey, long address, long previousSize, long newSize, long offset, int flags, int memoryTag) {
        if (offset != 0L || fileCacheKey == 0L || !Files.FS_CACHE_ENABLED || flags == 2) {
            return MmapCache.mremap0(fd, address, previousSize, newSize, offset, flags, memoryTag, memoryTag);
        }
        if (previousSize == 0L) {
            return this.cacheMmap(fd, fileCacheKey, newSize, offset, flags, memoryTag);
        }
        long unmapPtr = 0L;
        long unmapLen = 0L;
        int unmapTag = 0;
        long newAddress = 0L;
        MmapCache mmapCache = this;
        synchronized (mmapCache) {
            int addrMapIndex = this.mmapAddrCache.keyIndex(address);
            assert (addrMapIndex < 0) : "old address is not found in mmap cache";
            MmapCacheRecord record = this.mmapAddrCache.valueAt(addrMapIndex);
            int fdIndex = Integer.MAX_VALUE;
            if (newSize >= previousSize) {
                if (record.length >= newSize) {
                    return address;
                }
                fdIndex = this.mmapFileCache.keyIndex(fileCacheKey);
                if (fdIndex < 0) {
                    MmapCacheRecord updatedCacheRecord = this.mmapFileCache.valueAt(fdIndex);
                    if (updatedCacheRecord.length >= newSize) {
                        ++updatedCacheRecord.count;
                        newAddress = updatedCacheRecord.address;
                        assert (newAddress != 0L);
                        ++this.mmapReuseCount;
                        --record.count;
                        if (record.count == 0) {
                            this.mmapAddrCache.removeAt(addrMapIndex);
                            unmapPtr = record.address;
                            unmapLen = record.length;
                            unmapTag = record.memoryTag;
                            record.address = 0L;
                            if (this.recordPool.size() < 16384) {
                                this.recordPool.push(record);
                            }
                        }
                    }
                }
            }
            if (newAddress == 0L) {
                --record.count;
                if (record.count == 0) {
                    newAddress = MmapCache.mremap0(fd, record.address, record.length, newSize, offset, 1, record.memoryTag, memoryTag);
                    if (newAddress != -1L) {
                        record.address = newAddress;
                        record.length = newSize;
                        record.memoryTag = memoryTag;
                        this.mmapAddrCache.removeAt(addrMapIndex);
                        this.mmapAddrCache.put(newAddress, record);
                    }
                    record.count = 1;
                } else {
                    newAddress = MmapCache.mmap0(fd, newSize, 0L, 1, memoryTag);
                    if (newAddress != -1L) {
                        MmapCacheRecord newRecord = this.createMmapCacheRecord(fd, fileCacheKey, newSize, newAddress, memoryTag);
                        if (fdIndex != Integer.MAX_VALUE) {
                            this.mmapFileCache.putAt(fdIndex, fileCacheKey, newRecord);
                        } else {
                            this.mmapFileCache.put(fileCacheKey, newRecord);
                        }
                        this.mmapAddrCache.put(newAddress, newRecord);
                    }
                }
            }
        }
        if (unmapPtr != 0L) {
            MmapCache.unmap0(unmapPtr, unmapLen, unmapTag);
        }
        return newAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmap(long address, long len, int memoryTag) {
        int unmapTag;
        long unmapLen;
        long unmapPtr;
        if (address == 0L || len <= 0L) {
            return;
        }
        if (!Files.FS_CACHE_ENABLED) {
            MmapCache.unmap0(address, len, memoryTag);
            return;
        }
        MmapCache mmapCache = this;
        synchronized (mmapCache) {
            int addrMapIndex = this.mmapAddrCache.keyIndex(address);
            if (addrMapIndex > -1) {
                MmapCache.unmap0(address, len, memoryTag);
                return;
            }
            MmapCacheRecord record = this.mmapAddrCache.valueAt(addrMapIndex);
            --record.count;
            if (record.count != 0) {
                assert (record.count > -1);
                return;
            }
            this.mmapAddrCache.removeAt(addrMapIndex);
            int fdIndex = this.mmapFileCache.keyIndex(record.fileCacheKey);
            if (fdIndex < 0 && this.mmapFileCache.valueAt(fdIndex) == record) {
                this.mmapFileCache.removeAt(fdIndex);
            }
            unmapPtr = record.address;
            unmapLen = record.length;
            unmapTag = record.memoryTag;
            record.address = 0L;
            if (this.recordPool.size() < 16384) {
                this.recordPool.push(record);
            }
        }
        MmapCache.unmap0(unmapPtr, unmapLen, unmapTag);
    }

    private static long mmap0(int fd, long len, long offset, int flags, int memoryTag) {
        long address = Files.mmap0(fd, len, offset, flags, 0L);
        if (address != -1L) {
            Unsafe.recordMemAlloc(len, memoryTag);
        }
        return address;
    }

    private static long mremap0(int fd, long address, long previousSize, long newSize, long offset, int flags, int oldMemoryTag, int memoryTag) {
        if ((address = Files.mremap0(fd, address, previousSize, newSize, offset, flags)) != -1L) {
            if (oldMemoryTag == memoryTag) {
                Unsafe.recordMemAlloc(newSize - previousSize, memoryTag);
            } else {
                Unsafe.recordMemAlloc(newSize, memoryTag);
                Unsafe.recordMemAlloc(-previousSize, oldMemoryTag);
            }
        }
        return address;
    }

    private static void unmap0(long address, long len, int memoryTag) {
        if (address != 0L && Files.munmap0(address, len) != -1) {
            Unsafe.recordMemAlloc(-len, memoryTag);
        }
    }

    private MmapCacheRecord createMmapCacheRecord(int fd, long fileCacheKey, long len, long address, int memoryTag) {
        MmapCacheRecord rec = this.recordPool.pop();
        if (rec != null) {
            rec.of(fd, fileCacheKey, len, address, 1, memoryTag);
            return rec;
        }
        return new MmapCacheRecord(fd, fileCacheKey, len, address, 1, memoryTag);
    }

    private static class MmapCacheRecord {
        long address;
        int count;
        int fd;
        long fileCacheKey;
        long length;
        int memoryTag;

        public MmapCacheRecord(int fd, long fileCacheKey, long length, long address, int count, int memoryTag) {
            this.fd = fd;
            this.fileCacheKey = fileCacheKey;
            this.length = length;
            this.address = address;
            this.count = count;
            this.memoryTag = memoryTag;
        }

        public void of(int fd, long fileCacheKey, long len, long address, int count, int memoryTag) {
            this.fd = fd;
            this.fileCacheKey = fileCacheKey;
            this.length = len;
            this.address = address;
            this.count = count;
            this.memoryTag = memoryTag;
        }
    }
}

